/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import java.util.Random;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class RandomAccessInputStreamTest {
    private static final byte[] PAGE = new byte[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, -128, -124, -120, -116, -112, -108, -104, -100, -96, -92, -88, -84, -80, -76, -72, -68, -64, -60, -56, -52, -48, -44, -40, -36, -32, -28, -24, -20, -16, -12, -8, -4};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 2;
    private RandomAccessInputStream stream;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 2);
        this.stream = new RandomAccessInputStream(this.fileHandle);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)PAGE.length, (long)this.stream.length());
    }

    @Test
    public void testSequentialRead() throws IOException {
        this.stream.seek(0L);
        int i = 0;
        while ((long)i < this.stream.length()) {
            AssertJUnit.assertEquals((byte)PAGE[i], (byte)this.stream.readByte());
            ++i;
        }
    }

    @Test
    public void testReverseSequentialRead() throws IOException {
        this.stream.seek(this.stream.length() - 1L);
        for (int i = PAGE.length - 1; i >= 0; --i) {
            AssertJUnit.assertEquals((byte)PAGE[i], (byte)this.stream.readByte());
            if (this.stream.getFilePointer() < 2L) continue;
            this.stream.seek(this.stream.getFilePointer() - 2L);
        }
    }

    @Test
    public void testArrayRead() throws IOException {
        this.stream.seek(0L);
        byte[] buf = new byte[PAGE.length];
        this.stream.read(buf);
        for (int i = 0; i < PAGE.length; ++i) {
            AssertJUnit.assertEquals((byte)PAGE[i], (byte)buf[i]);
        }
    }

    @Test
    public void testRandomRead() throws IOException {
        long fp = PAGE.length / 2;
        this.stream.seek(fp);
        for (int i = 0; i < PAGE.length; ++i) {
            boolean forward = i % 2 == 0;
            int step = i / 2;
            if (forward) {
                this.stream.seek(fp + (long)step);
            } else {
                this.stream.seek(fp - (long)step);
            }
            AssertJUnit.assertEquals((byte)PAGE[(int)this.stream.getFilePointer()], (byte)this.stream.readByte());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBitRead() throws IOException {
        int count = 50000;
        int[] nums = new int[count];
        int[] len = new int[count];
        ByteArrayHandle handle = new ByteArrayHandle();
        RandomAccessOutputStream out = new RandomAccessOutputStream((IRandomAccess)handle);
        Random r = new Random();
        for (int i = 0; i < count; ++i) {
            nums[i] = i % 32 == 31 ? r.nextInt() : r.nextInt(1 << i % 32);
            len[i] = Integer.toBinaryString(nums[i]).length();
            out.writeBits(nums[i], len[i]);
        }
        out.close();
        in.seek(0L);
        try (RandomAccessInputStream in = new RandomAccessInputStream((IRandomAccess)handle);){
            for (int i = 0; i < count; ++i) {
                int c = r.nextInt(100);
                if (c >= 50) {
                    int v = in.readBits(len[i]);
                    AssertJUnit.assertEquals((int)v, (int)nums[i]);
                    continue;
                }
                in.skipBits((long)len[i]);
            }
        }
    }
}

