/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.model;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ome.xml.model.enums.*;
import ome.xml.model.enums.handlers.*;
import ome.xml.model.primitives.*;
import ome.units.quantity.*;
import ome.units.unit.Unit;

public class Detector extends ManufacturerSpec
{
  // Base: ManufacturerSpec -- Name: Detector -- Type: Detector -- modelBaseType: ManufacturerSpec -- langBaseType: Object

  // -- Constants --

  public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";

  /** Logger for this class. */
  private static final Logger LOGGER =
    LoggerFactory.getLogger(Detector.class);

  // -- Instance variables --

  // Gain property
  private Double gain;

  // Voltage property
  private ElectricPotential voltage;

  // Offset property
  private Double offset;

  // Zoom property
  private Double zoom;

  // AmplificationGain property
  private Double amplificationGain;

  // ID property
  private String id;

  // Type property
  private DetectorType type;

  // AnnotationRef reference (occurs more than once)
  private List<Annotation> annotationLinks = new ReferenceList<>();

  // Instrument_BackReference back reference
  private Instrument instrument;

  // -- Constructors --

  /** Default constructor. */
  public Detector()
  {
    super();
  }



  /**
   * Constructs Detector recursively from an XML DOM tree.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public Detector(Element element, OMEModel model)
    throws EnumerationException
  {
    update(element, model);
  }

  /** Copy constructor. */
  public Detector(Detector orig)
  {
    super(orig);
    gain = orig.gain;
    voltage = orig.voltage;
    offset = orig.offset;
    zoom = orig.zoom;
    amplificationGain = orig.amplificationGain;
    id = orig.id;
    type = orig.type;
    annotationLinks = orig.annotationLinks;
    instrument = orig.instrument;
  }

  // -- Custom content from Detector specific template --


  // -- OMEModelObject API methods --

  /**
   * Updates Detector recursively from an XML DOM tree. <b>NOTE:</b> No
   * properties are removed, only added or updated.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public void update(Element element, OMEModel model)
    throws EnumerationException
  {
    super.update(element, model);
    if (element.hasAttribute("Gain"))
    {
      // Attribute property Gain
      setGain(Double.valueOf(
        element.getAttribute("Gain")));
    }
    if (element.hasAttribute("Voltage"))
    {
      // Attribute property Voltage with unit companion VoltageUnit
      String unitSymbol = element.getAttribute("VoltageUnit");
      if ((unitSymbol == null) || (unitSymbol.isEmpty()))
      {
        // Use default value specified in the xsd model
        unitSymbol = getVoltageUnitXsdDefault();
      }
      UnitsElectricPotential modelUnit =
        UnitsElectricPotential.fromString(unitSymbol);
      Double baseValue = Double.valueOf(
        element.getAttribute("Voltage"));
      setVoltage(UnitsElectricPotentialEnumHandler.getQuantity(baseValue, modelUnit));
    }
    if (element.hasAttribute("Offset"))
    {
      // Attribute property Offset
      setOffset(Double.valueOf(
        element.getAttribute("Offset")));
    }
    if (element.hasAttribute("Zoom"))
    {
      // Attribute property Zoom
      setZoom(Double.valueOf(
        element.getAttribute("Zoom")));
    }
    if (element.hasAttribute("AmplificationGain"))
    {
      // Attribute property AmplificationGain
      setAmplificationGain(Double.valueOf(
        element.getAttribute("AmplificationGain")));
    }
    if (!element.hasAttribute("ID") && getID() == null)
    {
      // TODO: Should be its own exception
      throw new RuntimeException(
        "Detector missing required ID property.");
    }
    if (element.hasAttribute("ID"))
    {
      // ID property
      setID(String.valueOf(
        element.getAttribute("ID")));
      // Adding this model object to the model handler
      model.addModelObject(getID(), this);
    }
    if (element.hasAttribute("Type"))
    {
      // Attribute property which is an enumeration Type
      setType(DetectorType.fromString(
        element.getAttribute("Type")));
    }
    // Element reference AnnotationRef
    List<Element> AnnotationRef_nodeList =
      getChildrenByTagName(element, "AnnotationRef");
    for (Element AnnotationRef_element : AnnotationRef_nodeList)
    {
      AnnotationRef annotationLinks_reference = new AnnotationRef();
      annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
      model.addReference(this, annotationLinks_reference);
    }
  }

  // -- Detector API methods --

  public boolean link(Reference reference, OMEModelObject o)
  {
    if (reference instanceof AnnotationRef)
    {
      Annotation o_casted = (Annotation) o;
      o_casted.linkDetector(this);
      annotationLinks.add(o_casted);
      return true;
    }
    return super.link(reference, o);
  }

  // Property Gain
  public Double getGain()
  {
    return gain;
  }

  public void setGain(Double gain)
  {
    this.gain = gain;
  }

  // Property Voltage with unit companion VoltageUnit
  public ElectricPotential getVoltage()
  {
    return voltage;
  }

  public void setVoltage(ElectricPotential voltage)
  {
    this.voltage = voltage;
  }

  // Property VoltageUnit is a unit companion
  @SuppressWarnings("SameReturnValue")
  public static String getVoltageUnitXsdDefault()
  {
    return "V";
  }

  // Property Offset
  public Double getOffset()
  {
    return offset;
  }

  public void setOffset(Double offset)
  {
    this.offset = offset;
  }

  // Property Zoom
  public Double getZoom()
  {
    return zoom;
  }

  public void setZoom(Double zoom)
  {
    this.zoom = zoom;
  }

  // Property AmplificationGain
  public Double getAmplificationGain()
  {
    return amplificationGain;
  }

  public void setAmplificationGain(Double amplificationGain)
  {
    this.amplificationGain = amplificationGain;
  }

  // Property ID
  public String getID()
  {
    return id;
  }

  public void setID(String id)
  {
    this.id = id;
  }

  // Property Type
  public DetectorType getType()
  {
    return type;
  }

  public void setType(DetectorType type)
  {
    this.type = type;
  }

  // Reference which occurs more than once
  public int sizeOfLinkedAnnotationList()
  {
    return annotationLinks.size();
  }

  public List<Annotation> copyLinkedAnnotationList()
  {
    return new ArrayList<>(annotationLinks);
  }

  public Annotation getLinkedAnnotation(int index)
  {
    return annotationLinks.get(index);
  }

  public Annotation setLinkedAnnotation(int index, Annotation o)
  {
    return annotationLinks.set(index, o);
  }

  @SuppressWarnings("UnusedReturnValue")
  public boolean linkAnnotation(Annotation o)
  {

    o.linkDetector(this);
    return annotationLinks.add(o);
  }

  @SuppressWarnings("UnusedReturnValue")
  public boolean unlinkAnnotation(Annotation o)
  {

    o.unlinkDetector(this);
    return annotationLinks.remove(o);
  }

  // Property Instrument_BackReference
  public Instrument getInstrument()
  {
    return instrument;
  }

  public void setInstrument(Instrument instrument_BackReference)
  {
    this.instrument = instrument_BackReference;
  }

  public Element asXMLElement(Document document)
  {
    return asXMLElement(document, null);
  }

  public Element asXMLElement(Document document, Element Detector_element)
  {
    // Creating XML block for Detector
    if (Detector_element == null)
    {
      Detector_element =
        document.createElementNS(NAMESPACE, "Detector");
    }

    // Ensure any base annotations add their Elements first
    super.asXMLElement(document, Detector_element);

    if (gain != null)
    {
      // Attribute property Gain
      Detector_element.setAttribute("Gain", gain.toString());
    }
    if (voltage != null)
    {
      // Attribute property Voltage with units companion prop.unitsCompanion.name
      if (voltage.value() != null)
      {


        Detector_element.setAttribute("Voltage", voltage.value().toString());

      }
      if (voltage.unit() != null)
      {
        try
        {
          UnitsElectricPotential enumUnits = UnitsElectricPotential.fromString(voltage.unit().getSymbol());
          Detector_element.setAttribute("VoltageUnit", enumUnits.toString());
        } catch (EnumerationException e)
        {
          LOGGER.debug("Unable to create xml for Detector:VoltageUnit: {}", e.toString());
        }
      }
    }
    if (offset != null)
    {
      // Attribute property Offset
      Detector_element.setAttribute("Offset", offset.toString());
    }
    if (zoom != null)
    {
      // Attribute property Zoom
      Detector_element.setAttribute("Zoom", zoom.toString());
    }
    if (amplificationGain != null)
    {
      // Attribute property AmplificationGain
      Detector_element.setAttribute("AmplificationGain", amplificationGain.toString());
    }
    if (id != null)
    {
      // Attribute property ID
      Detector_element.setAttribute("ID", id);
    }
    if (type != null)
    {
      // Attribute property Type
      Detector_element.setAttribute("Type", type.toString());
    }
    if (annotationLinks != null)
    {
      // Reference property AnnotationRef which occurs more than once
      for (Annotation annotationLinks_value : annotationLinks)
      {
        AnnotationRef o = new AnnotationRef();
        o.setID(annotationLinks_value.getID());
        Element child =
          document.createElementNS(NAMESPACE, "AnnotationRef");
        o.asXMLElement(document, child);
        Detector_element.appendChild(child);
      }
    }
    // *** IGNORING *** Skipped back reference Instrument_BackReference

    return Detector_element;
  }
}
