/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class ReadFloatTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 63, -128, 0, 0, -65, -128, 0, 0, 64, 73, 15, -37, 127, 127, -1, -1, -1, -128, 0, 0, 127, -64, 0, 0};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)28L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequential() throws IOException {
        AssertJUnit.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(-1.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf((float)Math.PI), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(this.fileHandle.readFloat()));
    }

    @Test
    public void testSeekForward() throws IOException {
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((Object)Float.valueOf(-1.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf((float)Math.PI), (Object)Float.valueOf(this.fileHandle.readFloat()));
    }

    @Test
    public void testReset() throws IOException {
        AssertJUnit.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
    }

    @Test
    public void testSeekBack() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((Object)Float.valueOf(-1.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf((float)Math.PI), (Object)Float.valueOf(this.fileHandle.readFloat()));
    }

    @Test
    public void testRandomAccess() throws IOException {
        this.testSeekForward();
        this.testSeekBack();
        this.fileHandle.seek(0L);
        this.testReset();
    }
}

