/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

public class Swap {
    public static short swapShort(byte[] b, int offset) {
        int low = b[offset] & 0xFF;
        int high = b[offset + 1] & 0xFF;
        return (short)(high << 8 | low);
    }

    public static int swapInt(byte[] b, int offset) {
        int accum = 0;
        int shiftBy = 0;
        int i = offset;
        while (shiftBy < 32) {
            accum |= (b[i] & 0xFF) << shiftBy;
            shiftBy += 8;
            ++i;
        }
        return accum;
    }

    public static long swapLong(byte[] b, int offset) {
        long accum = 0L;
        int shiftBy = 0;
        int i = offset;
        while (shiftBy < 64) {
            long shiftedval = (long)(b[i] & 0xFF) << shiftBy;
            accum |= shiftedval;
            shiftBy += 8;
            ++i;
        }
        return accum;
    }

    public static float swapFloat(byte[] b, int offset) {
        int accum = 0;
        int shiftBy = 0;
        int i = offset;
        while (shiftBy < 32) {
            accum |= (b[i] & 0xFF) << shiftBy;
            shiftBy += 8;
            ++i;
        }
        return Float.intBitsToFloat(accum);
    }

    public static double swapDouble(byte[] b, int offset) {
        long accum = 0L;
        int shiftBy = 0;
        int i = offset;
        while (shiftBy < 64) {
            long shiftedval = (long)(b[i] & 0xFF) << shiftBy;
            accum |= shiftedval;
            shiftBy += 8;
            ++i;
        }
        return Double.longBitsToDouble(accum);
    }

    public static char swapChar(byte[] b, int offset) {
        int low = b[offset] & 0xFF;
        int high = b[offset + 1] & 0xFF;
        return (char)(high << 8 | low);
    }

    public static short swapShort(short s2) {
        return Swap.swapShort(Swap.shortToBytes(s2), 0);
    }

    public static int swapInt(int v) {
        return Swap.swapInt(Swap.intToBytes(v), 0);
    }

    public static long swapLong(long l) {
        return Swap.swapLong(Swap.longToBytes(l), 0);
    }

    public static float swapFloat(float v) {
        int l = Swap.swapInt(Float.floatToIntBits(v));
        return Float.intBitsToFloat(l);
    }

    public static double swapDouble(double v) {
        long l = Swap.swapLong(Double.doubleToLongBits(v));
        return Double.longBitsToDouble(l);
    }

    public static byte[] shortToBytes(short v) {
        byte[] b = new byte[2];
        int allbits = 255;
        for (int i = 0; i < 2; ++i) {
            b[1 - i] = (byte)((v & allbits << i * 8) >> i * 8);
        }
        return b;
    }

    public static byte[] intToBytes(int v) {
        byte[] b = new byte[4];
        int allbits = 255;
        for (int i = 0; i < 4; ++i) {
            b[3 - i] = (byte)((v & allbits << i * 8) >> i * 8);
        }
        return b;
    }

    public static byte[] longToBytes(long v) {
        byte[] b = new byte[8];
        long allbits = 255L;
        for (int i = 0; i < 8; ++i) {
            b[7 - i] = (byte)((v & allbits << i * 8) >> i * 8);
        }
        return b;
    }
}

