/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class VGSAMReader
extends FormatReader {
    public static final String VG_MAGIC_STRING = "VGS";
    public static final int PIXEL_OFFSET = 368;

    public VGSAMReader() {
        super("VG SAM", "dti");
        this.domains = new String[]{"Scanning Probe Microscopy (SPM)"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 3;
        if (!FormatTools.validStream(stream, 3, false)) {
            return false;
        }
        return stream.readString(3).indexOf(VG_MAGIC_STRING) >= 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(368L);
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        this.in.seek(348L);
        m4.sizeX = this.in.readInt();
        m4.sizeY = this.in.readInt();
        this.in.skipBytes(4);
        int bpp = this.in.readInt();
        this.addGlobalMeta("Bytes per pixel", bpp);
        m4.pixelType = FormatTools.pixelTypeFromBytes(bpp, false, bpp == 4);
        m4.littleEndian = false;
        m4.sizeZ = 1;
        m4.sizeC = 1;
        m4.sizeT = 1;
        m4.imageCount = 1;
        m4.rgb = false;
        m4.interleaved = false;
        m4.dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

