/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.util.Hashtable;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.OriginalMetadataAnnotation;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.OME;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.XMLAnnotation;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OMEXMLServiceTest {
    private OMEXMLService service;

    @BeforeMethod
    public void setUp() throws DependencyException {
        ServiceFactory sf = new ServiceFactory();
        this.service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
    }

    @Test
    public void testOriginalMetadata() throws ServiceException {
        OMEXMLMetadata metadata = this.service.createOMEXMLMetadata();
        this.service.populateOriginalMetadata(metadata, "testKey", "testValue");
        Hashtable metadataTable = this.service.getOriginalMetadata(metadata);
        AssertJUnit.assertEquals((int)metadataTable.size(), (int)1);
        AssertJUnit.assertTrue((boolean)"testValue".equals(metadataTable.get("testKey")));
        OME root = (OME)metadata.getRoot();
        StructuredAnnotations annotations = root.getStructuredAnnotations();
        AssertJUnit.assertEquals((int)annotations.sizeOfXMLAnnotationList(), (int)1);
        XMLAnnotation xmlAnn = annotations.getXMLAnnotation(0);
        String txt = "<OriginalMetadata><Key>testKey</Key><Value>testValue</Value></OriginalMetadata>";
        AssertJUnit.assertEquals((String)txt, (String)xmlAnn.getValue());
        OriginalMetadataAnnotation omAnn = (OriginalMetadataAnnotation)xmlAnn;
        AssertJUnit.assertEquals((String)"testValue", (String)omAnn.getValueForKey());
    }

    @Test
    public void testFloatingPointUnitProperty() throws ServiceException {
        Length propertyValue = new Length((Number)3.0, UNITS.PIXEL);
        StringBuffer expectedText = new StringBuffer();
        expectedText.append(" StrokeWidth=");
        expectedText.append('\"');
        expectedText.append(propertyValue.value().doubleValue());
        expectedText.append('\"');
        OMEXMLMetadata metadata = this.service.createOMEXMLMetadata();
        metadata.setROIID("test ROI", 0);
        metadata.setPointID("test point", 0, 0);
        metadata.setPointX(Double.valueOf(0.0), 0, 0);
        metadata.setPointY(Double.valueOf(0.0), 0, 0);
        metadata.setPointStrokeWidth(propertyValue, 0, 0);
        String xml = this.service.getOMEXML((MetadataRetrieve)metadata);
        AssertJUnit.assertTrue((boolean)xml.contains(expectedText));
    }

    @Test
    public void testIntegerUnitProperty() throws ServiceException {
        Length propertyValue = new Length((Number)12.0, UNITS.POINT);
        StringBuffer expectedText = new StringBuffer();
        expectedText.append(" FontSize=");
        expectedText.append('\"');
        expectedText.append(propertyValue.value().longValue());
        expectedText.append('\"');
        OMEXMLMetadata metadata = this.service.createOMEXMLMetadata();
        metadata.setROIID("test ROI", 0);
        metadata.setPointID("test point", 0, 0);
        metadata.setPointX(Double.valueOf(0.0), 0, 0);
        metadata.setPointY(Double.valueOf(0.0), 0, 0);
        metadata.setPointFontSize(propertyValue, 0, 0);
        String xml = this.service.getOMEXML((MetadataRetrieve)metadata);
        AssertJUnit.assertTrue((boolean)xml.contains(expectedText));
    }
}

