/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.util.Hashtable;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.Modulo;

public class CoreMetadata
implements Cloneable {
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public int sizeC;
    public int sizeT;
    public int thumbSizeX;
    public int thumbSizeY;
    public int pixelType;
    public int bitsPerPixel;
    public int imageCount;
    public Modulo moduloZ = new Modulo("Z");
    public Modulo moduloC = new Modulo("C");
    public Modulo moduloT = new Modulo("T");
    public String dimensionOrder;
    public boolean orderCertain;
    public boolean rgb;
    public boolean littleEndian;
    public boolean interleaved;
    public boolean indexed;
    public boolean falseColor = true;
    public boolean metadataComplete;
    public Hashtable<String, Object> seriesMetadata;
    public boolean thumbnail;
    public int resolutionCount = 1;

    public CoreMetadata() {
        this.seriesMetadata = new Hashtable();
    }

    public CoreMetadata(IFormatReader r, int coreIndex) {
        int currentIndex = r.getCoreIndex();
        r.setCoreIndex(coreIndex);
        this.sizeX = r.getSizeX();
        this.sizeY = r.getSizeY();
        this.sizeZ = r.getSizeZ();
        this.sizeC = r.getSizeC();
        this.sizeT = r.getSizeT();
        this.thumbSizeX = r.getThumbSizeX();
        this.thumbSizeY = r.getThumbSizeY();
        this.pixelType = r.getPixelType();
        this.bitsPerPixel = r.getBitsPerPixel();
        this.imageCount = r.getImageCount();
        this.dimensionOrder = r.getDimensionOrder();
        this.orderCertain = r.isOrderCertain();
        this.rgb = r.isRGB();
        this.littleEndian = r.isLittleEndian();
        this.interleaved = r.isInterleaved();
        this.indexed = r.isIndexed();
        this.falseColor = r.isFalseColor();
        this.metadataComplete = r.isMetadataComplete();
        this.seriesMetadata = new Hashtable();
        this.seriesMetadata.putAll(r.getSeriesMetadata());
        this.thumbnail = r.isThumbnailSeries();
        this.resolutionCount = r.getResolutionCount();
        this.moduloZ = r.getModuloZ();
        this.moduloC = r.getModuloC();
        this.moduloT = r.getModuloT();
        r.setCoreIndex(currentIndex);
    }

    public CoreMetadata(CoreMetadata c) {
        this.sizeX = c.sizeX;
        this.sizeY = c.sizeY;
        this.sizeZ = c.sizeZ;
        this.sizeC = c.sizeC;
        this.sizeT = c.sizeT;
        this.thumbSizeX = c.thumbSizeX;
        this.thumbSizeY = c.thumbSizeY;
        this.pixelType = c.pixelType;
        this.bitsPerPixel = c.bitsPerPixel;
        this.imageCount = c.imageCount;
        this.dimensionOrder = c.dimensionOrder;
        this.orderCertain = c.orderCertain;
        this.rgb = c.rgb;
        this.littleEndian = c.littleEndian;
        this.interleaved = c.interleaved;
        this.indexed = c.indexed;
        this.falseColor = c.falseColor;
        this.metadataComplete = c.metadataComplete;
        this.seriesMetadata = new Hashtable();
        this.seriesMetadata.putAll(c.seriesMetadata);
        this.thumbnail = c.thumbnail;
        this.resolutionCount = c.resolutionCount;
        this.moduloZ = new Modulo(c.moduloZ);
        this.moduloC = new Modulo(c.moduloC);
        this.moduloT = new Modulo(c.moduloT);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString() + ":");
        sb.append("\n\tsizeX = " + this.sizeX);
        sb.append("\n\tsizeY = " + this.sizeY);
        sb.append("\n\tsizeZ = " + this.sizeZ);
        sb.append("\n\tsizeC = " + this.sizeC);
        sb.append("\n\tsizeT = " + this.sizeT);
        sb.append("\n\tthumbSizeX = " + this.thumbSizeX);
        sb.append("\n\tthumbSizeY = " + this.thumbSizeY);
        sb.append("\n\tpixelType = " + FormatTools.getPixelTypeString(this.pixelType));
        sb.append("\n\tbitsPerPixel = " + this.bitsPerPixel);
        sb.append("\n\timageCount = " + this.imageCount);
        sb.append("\n\tdimensionOrder = " + this.dimensionOrder);
        sb.append("\n\torderCertain = " + this.orderCertain);
        sb.append("\n\trgb = " + this.rgb);
        sb.append("\n\tlittleEndian = " + this.littleEndian);
        sb.append("\n\tinterleaved = " + this.interleaved);
        sb.append("\n\tindexed = " + this.indexed);
        sb.append("\n\tfalseColor = " + this.falseColor);
        sb.append("\n\tmetadataComplete = " + this.metadataComplete);
        sb.append("\n\tseriesMetadata = " + this.seriesMetadata.size() + " keys");
        sb.append("\n\tthumbnail = " + this.thumbnail);
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public CoreMetadata clone(IFormatReader r, int coreIndex) {
        return new CoreMetadata(r, coreIndex);
    }
}

