/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Structure;
import ucar.nc2.iosp.IospHelper;

public class StructureDataDeep
extends StructureDataA {
    public static StructureDataDeep copy(StructureData sdata, StructureMembers members) {
        ArrayStructureBB abb = StructureDataDeep.copyToArrayBB(sdata, members, ByteOrder.BIG_ENDIAN);
        return new StructureDataDeep(abb);
    }

    public static ArrayStructureBB copyToArrayBB(ArrayStructure as, ByteOrder bo, boolean canonical) throws IOException {
        if (!canonical && as.getClass().equals(ArrayStructureBB.class)) {
            ArrayStructureBB abb = (ArrayStructureBB)as;
            ByteBuffer bb = abb.getByteBuffer();
            if (bo == null || bo.equals(bb.order())) {
                return abb;
            }
        }
        StructureMembers smo = as.getStructureMembers();
        StructureMembers sm = new StructureMembers(smo);
        ArrayStructureBB abb = new ArrayStructureBB(sm, as.getShape());
        ArrayStructureBB.setOffsets(sm);
        if (bo != null) {
            ByteBuffer bb = abb.getByteBuffer();
            bb.order(bo);
        }
        try (StructureDataIterator iter = as.getStructureDataIterator();){
            while (iter.hasNext()) {
                StructureDataDeep.copyToArrayBB(iter.next(), abb);
            }
        }
        return abb;
    }

    public static ArrayStructureBB copyToArrayBB(Structure s2, ArrayStructure as, ByteOrder bo) throws IOException {
        StructureMembers sm = s2.makeStructureMembers();
        ArrayStructureBB abb = new ArrayStructureBB(sm, as.getShape());
        ArrayStructureBB.setOffsets(sm);
        if (bo != null) {
            ByteBuffer bb = abb.getByteBuffer();
            bb.order(bo);
        }
        try (StructureDataIterator iter = as.getStructureDataIterator();){
            while (iter.hasNext()) {
                StructureDataDeep.copyToArrayBB(iter.next(), abb);
            }
        }
        return abb;
    }

    public static ArrayStructureBB copyToArrayBB(StructureData sdata) {
        return StructureDataDeep.copyToArrayBB(sdata, new StructureMembers(sdata.getStructureMembers()), ByteOrder.BIG_ENDIAN);
    }

    public static ArrayStructureBB copyToArrayBB(StructureData sdata, StructureMembers sm, ByteOrder bo) {
        int size = sm.getStructureSize();
        ByteBuffer bb = ByteBuffer.allocate(size);
        bb.order(bo);
        ArrayStructureBB abb = new ArrayStructureBB(sm, new int[]{1}, bb, 0);
        ArrayStructureBB.setOffsets(sm);
        StructureDataDeep.copyToArrayBB(sdata, abb);
        return abb;
    }

    public static int copyToArrayBB(StructureData sdata, ArrayStructureBB abb) {
        ByteBuffer bb = abb.getByteBuffer();
        int start = bb.limit();
        block22: for (StructureMembers.Member wantMember : abb.getMembers()) {
            StructureMembers.Member m4 = sdata.findMember(wantMember.getName());
            assert (m4 != null);
            assert (m4.getDataType() == wantMember.getDataType());
            DataType dtype = m4.getDataType();
            if (m4.isScalar()) {
                switch (dtype) {
                    case STRING: {
                        bb.putInt(abb.addObjectToHeap(sdata.getScalarString(m4)));
                        continue block22;
                    }
                    case FLOAT: {
                        bb.putFloat(sdata.getScalarFloat(m4));
                        continue block22;
                    }
                    case DOUBLE: {
                        bb.putDouble(sdata.getScalarDouble(m4));
                        continue block22;
                    }
                    case INT: 
                    case UINT: 
                    case ENUM4: {
                        bb.putInt(sdata.getScalarInt(m4));
                        continue block22;
                    }
                    case SHORT: 
                    case USHORT: 
                    case ENUM2: {
                        bb.putShort(sdata.getScalarShort(m4));
                        continue block22;
                    }
                    case BYTE: 
                    case UBYTE: 
                    case ENUM1: {
                        bb.put(sdata.getScalarByte(m4));
                        continue block22;
                    }
                    case CHAR: {
                        bb.put((byte)sdata.getScalarChar(m4));
                        continue block22;
                    }
                    case LONG: 
                    case ULONG: {
                        bb.putLong(sdata.getScalarLong(m4));
                        continue block22;
                    }
                    case STRUCTURE: {
                        StructureData sd = sdata.getScalarStructure(m4);
                        ArrayStructureBB out_abb = new ArrayStructureBB(sd.getStructureMembers(), new int[]{1}, bb, 0);
                        StructureDataDeep.copyToArrayBB(sd, out_abb);
                        continue block22;
                    }
                }
                throw new IllegalStateException("scalar " + (Object)((Object)dtype));
            }
            int n = m4.getSize();
            switch (dtype) {
                case STRING: {
                    String[] ss = sdata.getJavaArrayString(m4);
                    bb.putInt(abb.addObjectToHeap(ss));
                    break;
                }
                case FLOAT: {
                    float[] fdata = sdata.getJavaArrayFloat(m4);
                    for (int i = 0; i < n; ++i) {
                        bb.putFloat(fdata[i]);
                    }
                    continue block22;
                }
                case DOUBLE: {
                    double[] ddata = sdata.getJavaArrayDouble(m4);
                    for (int i = 0; i < n; ++i) {
                        bb.putDouble(ddata[i]);
                    }
                    continue block22;
                }
                case INT: 
                case ENUM4: {
                    int[] idata = sdata.getJavaArrayInt(m4);
                    for (int i = 0; i < n; ++i) {
                        bb.putInt(idata[i]);
                    }
                    continue block22;
                }
                case SHORT: 
                case ENUM2: {
                    short[] shdata = sdata.getJavaArrayShort(m4);
                    for (int i = 0; i < n; ++i) {
                        bb.putShort(shdata[i]);
                    }
                    continue block22;
                }
                case BYTE: 
                case ENUM1: {
                    byte[] bdata = sdata.getJavaArrayByte(m4);
                    for (int i = 0; i < n; ++i) {
                        bb.put(bdata[i]);
                    }
                    continue block22;
                }
                case CHAR: {
                    char[] cdata = sdata.getJavaArrayChar(m4);
                    bb.put(IospHelper.convertCharToByte(cdata));
                    break;
                }
                case LONG: {
                    long[] ldata = sdata.getJavaArrayLong(m4);
                    for (int i = 0; i < n; ++i) {
                        bb.putLong(ldata[i]);
                    }
                    continue block22;
                }
                default: {
                    throw new IllegalStateException("array " + (Object)((Object)dtype));
                }
                case SEQUENCE: 
            }
        }
        return bb.limit() - start;
    }

    private StructureDataDeep(ArrayStructureBB abb) {
        super(abb, 0);
    }
}

