/*
 * Decompiled with CFR 0.152.
 */
package ome.system.utests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import ome.system.OmeroContext;
import ome.system.utests.ChildListener;
import ome.system.utests.Collector;
import ome.system.utests.CtorOmeroContext;
import ome.system.utests.ParentListener;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.StaticApplicationContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ContextTest {
    public static final String C = "collector";
    public static final String FOO = "foo";
    public static final String BAR = "bar";
    public static final String BAX = "bax";

    @Test
    public void test_uniqueNonStaticContext() throws Exception {
        Properties p = new Properties();
        OmeroContext c1 = OmeroContext.getClientContext(p);
        OmeroContext c2 = OmeroContext.getClientContext(p);
        OmeroContext c3 = OmeroContext.getClientContext(new Properties());
        Assert.assertTrue((c1 != c2 ? 1 : 0) != 0);
        Assert.assertTrue((c1 != c3 ? 1 : 0) != 0);
        Assert.assertTrue((c2 != c3 ? 1 : 0) != 0);
    }

    @Test
    public void test_properOmeroContextCtorIsUsed() throws Exception {
        StaticApplicationContext beanRef = new StaticApplicationContext();
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addIndexedArgumentValue(0, new ArrayList());
        args.addIndexedArgumentValue(1, (Object)Boolean.TRUE);
        args.addIndexedArgumentValue(2, (Object)new RuntimeBeanReference("parent"));
        RootBeanDefinition parent = new RootBeanDefinition(StaticApplicationContext.class, null, null);
        parent.setInitMethodName("refresh");
        beanRef.registerBeanDefinition("parent", (BeanDefinition)parent);
        beanRef.registerBeanDefinition("test", (BeanDefinition)new RootBeanDefinition(CtorOmeroContext.class, args, null));
        beanRef.refresh();
        beanRef.getBean("test");
    }

    @Test(groups={"ticket:116"})
    public void test_refreshOrdering() throws Exception {
        Collector c = new Collector();
        HashMap<String, Collector> map = new HashMap<String, Collector>();
        map.put(C, c);
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addGenericArgumentValue(map);
        System.getProperties().setProperty(FOO, BAR);
        StaticApplicationContext parent = new StaticApplicationContext();
        parent.registerBeanDefinition("parentListener", (BeanDefinition)new RootBeanDefinition(ParentListener.class, args, null));
        PropertyPlaceholderConfigurer ppc = new PropertyPlaceholderConfigurer();
        parent.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)ppc);
        parent.refresh();
        parent.publishEvent((ApplicationEvent)new ContextRefreshedEvent((ApplicationContext)parent));
        Assert.assertTrue((boolean)c.parentRefreshed);
        c.reset();
        Assert.assertFalse((boolean)c.parentRefreshed);
        Assert.assertFalse((boolean)c.childRefreshed);
        StaticApplicationContext child = new StaticApplicationContext((ApplicationContext)parent);
        child.registerBeanDefinition("childListener", (BeanDefinition)new RootBeanDefinition(ChildListener.class, args, null));
        ConstructorArgumentValues stringArgs = new ConstructorArgumentValues();
        stringArgs.addGenericArgumentValue((Object)"${foo}");
        child.registerBeanDefinition("string", (BeanDefinition)new RootBeanDefinition(String.class, stringArgs, null));
        child.refresh();
        Assert.assertTrue((boolean)c.childRefreshed);
        Assert.assertFalse((boolean)c.parentRefreshed);
    }

    @Test(groups={"ticket:116"})
    public void test_refreshOrdering_withOmeroContext() throws Exception {
        OmeroContext ctx = OmeroContext.getInstance(ContextTest.class.getName());
        Map map = (Map)ctx.getBean("map");
        Collector c = (Collector)map.get(C);
        c.reset();
        Assert.assertFalse((boolean)c.childRefreshed);
        Assert.assertFalse((boolean)c.parentRefreshed);
        ctx.refresh();
        Assert.assertTrue((boolean)c.childRefreshed);
        Assert.assertFalse((boolean)c.parentRefreshed);
        c.reset();
        ctx.refreshAll();
        map = (Map)ctx.getBean("map");
        c = (Collector)map.get(C);
        Assert.assertTrue((boolean)c.childRefreshed);
        Assert.assertTrue((boolean)c.parentRefreshed);
    }
}

