/*
 * Decompiled with CFR 0.152.
 */
package ome.testing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Paths {
    private static Logger log = LoggerFactory.getLogger(Paths.class);
    public static final Long EXISTS = new Long(-3L);
    public static final Long WILDCARD = new Long(-2L);
    public static final Long NULL_IMAGE = new Long(-1L);
    public static final Long CG = new Long(0L);
    public static final Long C = new Long(1L);
    public static final Long I = new Long(2L);
    List cg = new ArrayList();
    List c = new ArrayList();
    List i = new ArrayList();
    List removed = new ArrayList();
    Long[] singlePath = null;

    public Paths(List data) {
        if (data == null) {
            throw new ApiUsageException("Data argument to Paths constructor may not be null.");
        }
        List cgciPaths = data;
        for (Map m : cgciPaths) {
            Long cg = (Long)m.get("cg");
            Long c = (Long)m.get("c");
            Long i = m.get("i") == null ? NULL_IMAGE : (Long)m.get("i");
            this.add(cg, c, i);
            if (this.singlePath != null || i == NULL_IMAGE) continue;
            this.singlePath = this.get(new Long(this.size() - 1));
        }
        log.info(this.toString());
        if (this.singlePath == null) {
            log.warn("No path found with non-null image.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int t = 0; t < this.cg.size(); ++t) {
            if (!this.removed.contains(new Long(t))) {
                sb.append(t + ":\t");
                sb.append(this.cg.get(t));
                sb.append("/");
                sb.append(this.c.get(t));
                sb.append("/");
                sb.append((NULL_IMAGE.equals(this.i.get(t)) ? "EMPTY" : this.i.get(t)) + "\n");
                continue;
            }
            sb.append(t + ":\tREMOVED");
        }
        return sb.toString();
    }

    public void add(Long newCg, Long newC, Long newI) {
        this.cg.add(newCg);
        this.c.add(newC);
        this.i.add(newI);
    }

    public boolean remove(Long t) {
        this.removed.add(t);
        return true;
    }

    public boolean remove(Long removeCg, Long removeC, Long removeI) {
        Set n = this.find(removeCg, removeC, removeI);
        return n.size() < 1 ? false : this.removed.addAll(n);
    }

    public Set find(Long testCg, Long testC, Long testI) {
        HashSet<Long> result = new HashSet<Long>();
        for (int n = 0; n < this.cg.size(); ++n) {
            Long N = new Long(n);
            if (!this.cg.get(n).equals(testCg) && testCg != WILDCARD && testCg != EXISTS || !this.c.get(n).equals(testC) && testC != WILDCARD && testC != EXISTS || !this.i.get(n).equals(testI) && testI != WILDCARD && (testI != EXISTS || this.i.get(n) == NULL_IMAGE) || this.removed.contains(N)) continue;
            result.add(N);
        }
        return result;
    }

    public Long[] get(Long n) {
        Long[] values = new Long[3];
        values[Paths.CG.intValue()] = (Long)this.cg.get(n.intValue());
        values[Paths.C.intValue()] = (Long)this.c.get(n.intValue());
        values[Paths.I.intValue()] = (Long)this.i.get(n.intValue());
        return values;
    }

    public int size() {
        return this.cg.size() - this.removed.size();
    }

    public Set uniqueGroups() {
        return new HashSet(this.cg);
    }

    public Set uniqueCats() {
        return new HashSet(this.c);
    }

    public Set uniqueImages() {
        return new HashSet(this.i);
    }

    public Set unique(Long which, Long testCg, Long testC, Long testI) {
        if (which.equals(CG) || which.equals(C) || which.equals(I)) {
            Set retVal = this.find(testCg, testC, testI);
            HashSet<Long> collect = new HashSet<Long>();
            for (Long idx : retVal) {
                Long[] values = this.get(idx);
                collect.add(values[which.intValue()]);
            }
            return collect;
        }
        throw new ApiUsageException(which + " is an unknown index.");
    }

    public Long[] singlePath() {
        Long[] tmp = new Long[this.singlePath.length];
        System.arraycopy(this.singlePath, 0, tmp, 0, tmp.length);
        return tmp;
    }
}

