/*
 * Decompiled with CFR 0.152.
 */
package ome.testing;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public abstract class SqlPropertiesParser {
    private static Logger log = LoggerFactory.getLogger(SqlPropertiesParser.class);
    static MyPropertyPlaceholderConfigurer prc = new MyPropertyPlaceholderConfigurer();

    protected static void load(Properties props, String filename) {
        InputStream is = SqlPropertiesParser.class.getClassLoader().getResourceAsStream(filename);
        try {
            props.load(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse properties file " + filename, e);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to close properties file " + filename, e);
                }
            }
        }
    }

    public static Map parse(String[] filenames) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Properties props = new Properties();
        for (int i = 0; i < filenames.length; ++i) {
            SqlPropertiesParser.load(props, filenames[i]);
        }
        prc.setProperties(props);
        prc.postProcessBeanFactory(null);
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            result.put(name, prc.doIt(props.getProperty(name)));
        }
        for (String name : result.keySet()) {
            String value = (String)result.get(name);
            if (value.startsWith("select")) continue;
            String[] strValues = value.split("\\s*,\\s*");
            Long[] longValues = new Long[strValues.length];
            for (int i = 0; i < strValues.length; ++i) {
                longValues[i] = Long.valueOf(strValues[i]);
            }
            result.put(name, Arrays.asList(longValues));
        }
        return result;
    }

    static class MyPropertyPlaceholderConfigurer
    extends PropertyPlaceholderConfigurer {
        MyPropertyPlaceholderConfigurer() {
        }

        protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        }

        public String doIt(String property) {
            try {
                return this.parseStringValue(property, this.mergeProperties(), new HashSet());
            }
            catch (Exception e) {
                throw new RuntimeException("Error in evaluating embedded properties.", e);
            }
        }
    }
}

