/*
 * Decompiled with CFR 0.152.
 */
package ome.services.eventlogs;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import ome.model.IObject;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import ome.model.core.Image;
import ome.model.meta.EventLog;
import ome.model.screen.Plate;
import ome.model.screen.Screen;
import ome.services.eventlogs.EventLogFailure;
import ome.services.eventlogs.PersistentEventLogLoader;
import ome.system.metrics.Counter;
import ome.system.metrics.Metrics;
import ome.system.metrics.NullMetrics;
import ome.system.metrics.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class EventLogQueue
extends PersistentEventLogLoader {
    public static final int DEFAULT_MAX = 1000000;
    private final List<String> types;
    private final List<String> actions;
    private final Data data;
    private final int max;
    private final Timer lookupTime;
    private final Timer processTime;
    private final Counter priorityCount;
    private final Counter regularCount;
    private final Counter failureCount;
    private final Counter nextCount;
    private int batchCount;
    private WrappedEventLog lastReturned;

    public EventLogQueue() {
        this((Metrics)new NullMetrics(), 1000000, new String[]{Project.class.getName(), Dataset.class.getName(), Screen.class.getName(), Plate.class.getName(), Image.class.getName()}, new String[]{"INSERT", "UPDATE", "REINDEX", "DELETE"});
    }

    public EventLogQueue(Metrics metrics, int max, String[] types, String[] actions) {
        this.lookupTime = metrics.timer((Object)this, "lookupTime");
        this.processTime = metrics.timer((Object)this, "processTime");
        this.nextCount = metrics.counter((Object)this, "nextCount");
        this.priorityCount = metrics.counter((Object)this, "priorityCount");
        this.regularCount = metrics.counter((Object)this, "regularCount");
        this.failureCount = metrics.counter((Object)this, "failureCount");
        long memory = Runtime.getRuntime().maxMemory();
        long queueBytes = max * 100;
        if ((double)queueBytes > 0.25 * (double)memory) {
            this.max = max / 10;
            this.log.warn("max_partition_size set to more than 25% of total heap size. Reducing by 1/10th to {}", (Object)this.max);
        } else {
            this.max = max;
        }
        this.types = Arrays.asList(types);
        this.actions = Arrays.asList(actions);
        this.data = new Data(this.priorityCount, this.regularCount, this.failureCount, this.types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Object[]> lookup() {
        Timer.Context ctx = this.lookupTime.time();
        try {
            long current = this.getCurrentId();
            List rv = this.sql.getEventLogPartitions(this.types, this.actions, current, (long)this.max);
            this.log.debug(String.format("objects found searching from %s (max: %s): %s", current, this.max, rv.size()));
            List list = rv;
            return list;
        }
        finally {
            ctx.stop();
        }
    }

    protected int load(List<Object[]> rows) {
        int loaded = 0;
        for (Object[] row : rows) {
            if (!(row != null && row.length == 5 && row[0] instanceof Long && row[1] instanceof String && row[2] instanceof Long && row[3] instanceof String && row[4] instanceof Integer)) {
                this.log.error("Invalid row data: " + Arrays.toString(row));
                continue;
            }
            if (!this.load((Long)row[0], (String)row[1], (Long)row[2], (String)row[3], (Integer)row[4])) continue;
            ++loaded;
        }
        return loaded;
    }

    protected boolean load(Long eventLogId, String type, Long objId, String action, Integer skipped) {
        boolean added = false;
        Data.Entries entries = this.data.entries(type);
        Entry entry = entries.get(objId);
        if (entry == null) {
            entry = new Entry(eventLogId, type, objId, action, skipped);
            entries.addRegular(entry);
            added = true;
        } else {
            entry.update(eventLogId, action, skipped);
        }
        return added;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent arg0) {
        if (arg0 instanceof EventLogFailure) {
            EventLogFailure failure = (EventLogFailure)arg0;
            if (failure.wasSource(this)) {
                if (this.lastReturned != failure.log) {
                    this.log.error("lastReturned is not failure item!");
                }
                this.lastReturned.timer.stop();
                this.lastReturned = null;
                this.data.fail(failure);
            }
        } else {
            super.onApplicationEvent(arg0);
        }
    }

    private EventLog offer(Entry entry) {
        if (this.lastReturned != null) {
            this.lastReturned.timer.stop();
            Entry last = this.lastReturned.entry;
            last.pass();
            if (last.eventLog >= 0L) {
                this.setCurrentId(last.eventLog);
            }
            this.log.debug(String.format("Successfully handled %s. Skipped: %s", last, last.skipped));
            this.lastReturned = null;
        }
        if (entry.state != State.OPEN) {
            return null;
        }
        this.lastReturned = new WrappedEventLog(entry, this.processTime.time());
        return this.lastReturned;
    }

    @Override
    public boolean hasNext() {
        if (this.isStopSet()) {
            return false;
        }
        ++this.batchCount;
        if (this.batchCount > this.batchSize) {
            this.batchCount = 0;
            return false;
        }
        if (this.data.hasNext()) {
            return true;
        }
        return this.load(this.lookup()) > 0;
    }

    @Override
    public EventLog next() {
        this.nextCount.inc();
        return this.offer(this.data.next());
    }

    @Override
    protected EventLog query() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long more() {
        return 0L;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean addEventLog(Class<? extends IObject> cls, long id) {
        boolean debug = this.log.isDebugEnabled();
        String type = cls.getName();
        Data.Entries entries = this.data.entries(type);
        if (entries == null) {
            if (debug) {
                this.log.debug("Type not available for backlog:" + type);
            }
            return false;
        }
        Entry entry = entries.get(id);
        if (entry != null) {
            if (debug) {
                this.log.debug("Entry already scheduled:" + entry);
            }
            ++entry.skipped;
            return false;
        }
        entry = new Entry(-1L, type, id, "REINDEX", 0);
        entries.addPriority(entry);
        if (debug) {
            this.log.debug("New backlog entry:" + entry);
        }
        return true;
    }

    private static class Data
    implements Serializable {
        private static final Logger log = LoggerFactory.getLogger(Data.class);
        private static final long serialVersionUID = 1L;
        private final Entries[] entriesArray;
        private final LinkedList<Entry> priorityQ = new LinkedList();
        private final LinkedList<Entry> regularQ = new LinkedList();
        private final LinkedList<WrappedEventLog> failureQ = new LinkedList();
        private final List<String> types;
        private final transient Counter priorityCount;
        private final transient Counter regularCount;
        private final transient Counter failureCount;

        public Data(Counter priority, Counter regular, Counter failure, List<String> types) {
            this.priorityCount = priority;
            this.regularCount = regular;
            this.failureCount = failure;
            this.types = types;
            this.entriesArray = new Entries[types.size()];
            for (int i = 0; i < types.size(); ++i) {
                this.entriesArray[i] = new Entries(new HashMap<Long, Entry>());
            }
        }

        protected Entries entries(String type) {
            int idx = this.types.indexOf(type);
            if (idx >= 0) {
                return this.entriesArray[idx];
            }
            return null;
        }

        public boolean hasNext() {
            if (!this.priorityQ.isEmpty()) {
                return true;
            }
            return !this.regularQ.isEmpty();
        }

        public Entry next() {
            String which = null;
            Entry entry = null;
            if (!this.priorityQ.isEmpty()) {
                entry = this.priorityQ.remove(0);
                this.priorityCount.dec();
                which = "priority";
            } else if (!this.regularQ.isEmpty()) {
                entry = this.regularQ.remove(0);
                this.regularCount.dec();
                which = "regular";
            } else {
                throw new NoSuchElementException();
            }
            this.entries(entry.objType).entries.remove(entry.objId);
            return entry;
        }

        public void fail(EventLogFailure failure) {
            WrappedEventLog wrapped = (WrappedEventLog)failure.log;
            this.failureQ.add(wrapped);
            wrapped.entry.fail();
            this.failureCount.inc();
        }

        private class Entries
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final Map<Long, Entry> entries;

            public Entries(Map<Long, Entry> entries) {
                this.entries = entries;
            }

            public Entry get(Long objId) {
                return this.entries.get(objId);
            }

            private void addRegular(Entry entry) {
                this.entries.put(entry.objId, entry);
                Data.this.regularQ.add(entry);
                Data.this.regularCount.inc();
            }

            public void addPriority(Entry entry) {
                this.entries.put(entry.objId, entry);
                Data.this.priorityQ.add(entry);
                Data.this.priorityCount.inc();
            }
        }
    }

    private static class WrappedEventLog
    extends EventLog {
        private static final long serialVersionUID = 1L;
        private final Entry entry;
        private final Timer.Context timer;

        WrappedEventLog(Entry e, Timer.Context timer) {
            this.timer = timer;
            this.entry = e;
            this.setId(e.eventLog);
            this.setAction(e.action);
            this.setEntityType(e.objType);
            this.setEntityId(e.objId);
        }
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        long eventLog;
        final String objType;
        final long objId;
        String action;
        int skipped;
        State state = State.OPEN;

        Entry(long log, String type, long id, String action, int skipped) {
            this.eventLog = log;
            this.objType = type;
            this.objId = id;
            this.action = action;
            this.skipped = skipped;
        }

        public void update(long eventLogId, String action, int skipped) {
            this.eventLog = eventLogId;
            this.action = action;
            this.skipped = skipped;
        }

        public void pass() {
            this.state = State.PASS;
        }

        public void fail() {
            this.state = State.FAIL;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Entry[");
            sb.append(this.eventLog);
            sb.append("]");
            sb.append("<");
            sb.append(this.objType);
            sb.append(":");
            sb.append(this.objId);
            sb.append("=");
            sb.append(this.action);
            sb.append(">");
            return sb.toString();
        }
    }

    static enum State {
        OPEN,
        PASS,
        FAIL;

    }
}

