/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.datum;

import java.io.Serializable;

public final class Ellipsoid
implements Cloneable,
Serializable {
    public String name;
    public String shortName;
    public double equatorRadius = 1.0;
    public double poleRadius = 1.0;
    public double eccentricity = 1.0;
    public double eccentricity2 = 1.0;
    public static final Ellipsoid INTERNATIONAL = new Ellipsoid("intl", 6378388.0, 0.0, 297.0, "International 1909 (Hayford)");
    public static final Ellipsoid BESSEL = new Ellipsoid("bessel", 6377397.155, 0.0, 299.1528128, "Bessel 1841");
    public static final Ellipsoid CLARKE_1866 = new Ellipsoid("clrk66", 6378206.4, 6356583.8, 0.0, "Clarke 1866");
    public static final Ellipsoid CLARKE_1880 = new Ellipsoid("clrk80", 6378249.145, 0.0, 293.4663, "Clarke 1880 mod.");
    public static final Ellipsoid AIRY = new Ellipsoid("airy", 6377563.396, 6356256.91, 0.0, "Airy 1830");
    public static final Ellipsoid WGS60 = new Ellipsoid("WGS60", 6378165.0, 0.0, 298.3, "WGS 60");
    public static final Ellipsoid WGS66 = new Ellipsoid("WGS66", 6378145.0, 0.0, 298.25, "WGS 66");
    public static final Ellipsoid WGS72 = new Ellipsoid("WGS72", 6378135.0, 0.0, 298.26, "WGS 72");
    public static final Ellipsoid WGS84 = new Ellipsoid("WGS84", 6378137.0, 0.0, 298.257223563, "WGS 84");
    public static final Ellipsoid KRASSOVSKY = new Ellipsoid("krass", 6378245.0, 0.0, 298.3, "Krassovsky, 1942");
    public static final Ellipsoid EVEREST = new Ellipsoid("evrst30", 6377276.345, 0.0, 300.8017, "Everest 1830");
    public static final Ellipsoid INTERNATIONAL_1967 = new Ellipsoid("new_intl", 6378157.5, 6356772.2, 0.0, "New International 1967");
    public static final Ellipsoid GRS80 = new Ellipsoid("GRS80", 6378137.0, 0.0, 298.257222101, "GRS 1980 (IUGG, 1980)");
    public static final Ellipsoid AUSTRALIAN = new Ellipsoid("australian", 6378160.0, 6356774.7, 298.25, "Australian");
    public static final Ellipsoid MERIT = new Ellipsoid("MERIT", 6378137.0, 0.0, 298.257, "MERIT 1983");
    public static final Ellipsoid SGS85 = new Ellipsoid("SGS85", 6378136.0, 0.0, 298.257, "Soviet Geodetic System 85");
    public static final Ellipsoid IAU76 = new Ellipsoid("IAU76", 6378140.0, 0.0, 298.257, "IAU 1976");
    public static final Ellipsoid APL4_9 = new Ellipsoid("APL4.9", 6378137.0, 0.0, 298.25, "Appl. Physics. 1965");
    public static final Ellipsoid NWL9D = new Ellipsoid("NWL9D", 6378145.0, 0.0, 298.25, "Naval Weapons Lab., 1965");
    public static final Ellipsoid MOD_AIRY = new Ellipsoid("mod_airy", 6377340.189, 6356034.446, 0.0, "Modified Airy");
    public static final Ellipsoid ANDRAE = new Ellipsoid("andrae", 6377104.43, 0.0, 300.0, "Andrae 1876 (Den., Iclnd.)");
    public static final Ellipsoid AUST_SA = new Ellipsoid("aust_SA", 6378160.0, 0.0, 298.25, "Australian Natl & S. Amer. 1969");
    public static final Ellipsoid GRS67 = new Ellipsoid("GRS67", 6378160.0, 0.0, 298.247167427, "GRS 67 (IUGG 1967)");
    public static final Ellipsoid BESS_NAM = new Ellipsoid("bess_nam", 6377483.865, 0.0, 299.1528128, "Bessel 1841 (Namibia)");
    public static final Ellipsoid CPM = new Ellipsoid("CPM", 6375738.7, 0.0, 334.29, "Comm. des Poids et Mesures 1799");
    public static final Ellipsoid DELMBR = new Ellipsoid("delmbr", 6376428.0, 0.0, 311.5, "Delambre 1810 (Belgium)");
    public static final Ellipsoid ENGELIS = new Ellipsoid("engelis", 6378136.05, 0.0, 298.2566, "Engelis 1985");
    public static final Ellipsoid EVRST48 = new Ellipsoid("evrst48", 6377304.063, 0.0, 300.8017, "Everest 1948");
    public static final Ellipsoid EVRST56 = new Ellipsoid("evrst56", 6377301.243, 0.0, 300.8017, "Everest 1956");
    public static final Ellipsoid EVRTS69 = new Ellipsoid("evrst69", 6377295.664, 0.0, 300.8017, "Everest 1969");
    public static final Ellipsoid EVRTSTSS = new Ellipsoid("evrstSS", 6377298.556, 0.0, 300.8017, "Everest (Sabah & Sarawak)");
    public static final Ellipsoid FRSCH60 = new Ellipsoid("fschr60", 6378166.0, 0.0, 298.3, "Fischer (Mercury Datum) 1960");
    public static final Ellipsoid FSRCH60M = new Ellipsoid("fschr60m", 6378155.0, 0.0, 298.3, "Modified Fischer 1960");
    public static final Ellipsoid FSCHR68 = new Ellipsoid("fschr68", 6378150.0, 0.0, 298.3, "Fischer 1968");
    public static final Ellipsoid HELMERT = new Ellipsoid("helmert", 6378200.0, 0.0, 298.3, "Helmert 1906");
    public static final Ellipsoid HOUGH = new Ellipsoid("hough", 6378270.0, 0.0, 297.0, "Hough");
    public static final Ellipsoid INTL = new Ellipsoid("intl", 6378388.0, 0.0, 297.0, "International 1909 (Hayford)");
    public static final Ellipsoid KAULA = new Ellipsoid("kaula", 6378163.0, 0.0, 298.24, "Kaula 1961");
    public static final Ellipsoid LERCH = new Ellipsoid("lerch", 6378139.0, 0.0, 298.257, "Lerch 1979");
    public static final Ellipsoid MPRTS = new Ellipsoid("mprts", 6397300.0, 0.0, 191.0, "Maupertius 1738");
    public static final Ellipsoid PLESSIS = new Ellipsoid("plessis", 6376523.0, 6355863.0, 0.0, "Plessis 1817 France)");
    public static final Ellipsoid SEASIA = new Ellipsoid("SEasia", 6378155.0, 6356773.3205, 0.0, "Southeast Asia");
    public static final Ellipsoid WALBECK = new Ellipsoid("walbeck", 6376896.0, 6355834.8467, 0.0, "Walbeck");
    public static final Ellipsoid NAD27 = new Ellipsoid("NAD27", 6378249.145, 0.0, 293.4663, "NAD27: Clarke 1880 mod.");
    public static final Ellipsoid NAD83 = new Ellipsoid("NAD83", 6378137.0, 0.0, 298.257222101, "NAD83: GRS 1980 (IUGG, 1980)");
    public static final Ellipsoid SPHERE = new Ellipsoid("sphere", 6371008.7714, 6371008.7714, 0.0, "Sphere");
    public static final Ellipsoid[] ellipsoids = new Ellipsoid[]{BESSEL, CLARKE_1866, CLARKE_1880, AIRY, WGS60, WGS66, WGS72, WGS84, KRASSOVSKY, EVEREST, INTERNATIONAL_1967, GRS80, AUSTRALIAN, MERIT, SGS85, IAU76, APL4_9, NWL9D, MOD_AIRY, ANDRAE, AUST_SA, GRS67, BESS_NAM, CPM, DELMBR, ENGELIS, EVRST48, EVRST56, EVRTS69, EVRTSTSS, FRSCH60, FSRCH60M, FSCHR68, HELMERT, HOUGH, INTL, KAULA, LERCH, MPRTS, PLESSIS, SEASIA, WALBECK, NAD27, NAD83, SPHERE};

    public Ellipsoid() {
    }

    public Ellipsoid(String shortName, double equatorRadius, double poleRadius, double reciprocalFlattening, String name) {
        this.shortName = shortName;
        this.name = name;
        this.equatorRadius = equatorRadius;
        this.poleRadius = poleRadius;
        if (poleRadius == 0.0 && reciprocalFlattening == 0.0) {
            throw new IllegalArgumentException("One of poleRadius or reciprocalFlattening must be specified");
        }
        if (reciprocalFlattening != 0.0) {
            double flattening;
            double f = flattening = 1.0 / reciprocalFlattening;
            this.eccentricity2 = 2.0 * f - f * f;
            this.poleRadius = equatorRadius * Math.sqrt(1.0 - this.eccentricity2);
        } else {
            this.eccentricity2 = 1.0 - poleRadius * poleRadius / (equatorRadius * equatorRadius);
        }
        this.eccentricity = Math.sqrt(this.eccentricity2);
    }

    public Ellipsoid(String shortName, double equatorRadius, double eccentricity2, String name) {
        this.shortName = shortName;
        this.name = name;
        this.equatorRadius = equatorRadius;
        this.setEccentricitySquared(eccentricity2);
    }

    public Object clone() {
        try {
            Ellipsoid e = (Ellipsoid)super.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setEquatorRadius(double equatorRadius) {
        this.equatorRadius = equatorRadius;
    }

    public double getEquatorRadius() {
        return this.equatorRadius;
    }

    public double getA() {
        return this.equatorRadius;
    }

    public double getB() {
        return this.poleRadius;
    }

    public void setEccentricitySquared(double eccentricity2) {
        this.eccentricity2 = eccentricity2;
        this.poleRadius = this.equatorRadius * Math.sqrt(1.0 - eccentricity2);
        this.eccentricity = Math.sqrt(eccentricity2);
    }

    public double getEccentricitySquared() {
        return this.eccentricity2;
    }

    public boolean isEqual(Ellipsoid e) {
        return this.equatorRadius == e.equatorRadius && this.eccentricity2 == e.eccentricity2;
    }

    public boolean isEqual(Ellipsoid e, double e2Tolerance) {
        if (this.equatorRadius != e.equatorRadius) {
            return false;
        }
        return !(Math.abs(this.eccentricity2 - e.eccentricity2) > e2Tolerance);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() | 7 * this.shortName.hashCode() | 17 * Double.valueOf(this.equatorRadius).hashCode() | 29 * Double.valueOf(this.poleRadius).hashCode() | 37 * Double.valueOf(this.eccentricity).hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof Ellipsoid) {
            Ellipsoid e = (Ellipsoid)that;
            if (this.name == null && e.name != null) {
                return false;
            }
            if (!this.name.equals(e.name)) {
                return false;
            }
            if (this.shortName == null && e.shortName != null) {
                return false;
            }
            if (!this.shortName.equals(e.shortName)) {
                return false;
            }
            return this.equatorRadius == e.equatorRadius && this.poleRadius == e.poleRadius && this.eccentricity == e.eccentricity;
        }
        return false;
    }
}

