/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway;

import com.google.common.base.Objects;
import omero.gateway.ServerInformation;
import omero.gateway.model.ExperimenterData;

public class SecurityContext {
    private long groupID = -1L;
    private ExperimenterData experimenter;
    private boolean sudo;
    private ServerInformation serverInformation;
    private float compression = 0.85f;

    public SecurityContext(long groupID) {
        this.groupID = groupID;
        this.experimenter = null;
        this.sudo = false;
    }

    public void sudo() {
        this.sudo = true;
    }

    public boolean isSudo() {
        return this.sudo;
    }

    public void setExperimenter(ExperimenterData experimenter) {
        this.experimenter = experimenter;
    }

    public long getExperimenter() {
        if (this.experimenter == null) {
            return -1L;
        }
        return this.experimenter.getId();
    }

    public ExperimenterData getExperimenterData() {
        return this.experimenter;
    }

    public long getGroupID() {
        return this.groupID;
    }

    public ServerInformation getServerInformation() {
        return this.serverInformation;
    }

    public void setServerInformation(ServerInformation serverInformation) {
        this.serverInformation = serverInformation;
    }

    public float getCompression() {
        return this.compression;
    }

    public void setCompression(float compression) {
        this.compression = compression >= 0.01f && compression <= 1.0f ? compression : 0.85f;
    }

    public SecurityContext copy() {
        SecurityContext ctx = new SecurityContext(this.groupID);
        ctx.setExperimenter(this.experimenter);
        ctx.setServerInformation(this.serverInformation);
        ctx.setCompression(this.compression);
        return ctx;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getGroupID(), this.getServerInformation(), this.getExperimenter()});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return Objects.equal((Object)((SecurityContext)obj).getGroupID(), (Object)this.getGroupID()) && Objects.equal((Object)((SecurityContext)obj).getServerInformation(), (Object)this.getServerInformation()) && Objects.equal((Object)((SecurityContext)obj).getExperimenter(), (Object)this.getExperimenter());
    }

    public String toString() {
        return "SecurityContext [groupID=" + this.groupID + ", experimenter=" + this.experimenter + ", sudo=" + this.sudo + ", serverInformation=" + this.serverInformation + ", compression=" + this.compression + "]";
    }
}

