/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import omero.RDouble;
import omero.RString;
import omero.gateway.model.ShapeData;
import omero.model.Rectangle;
import omero.model.RectangleI;
import omero.model.Shape;
import omero.rtypes;

public class RectangleData
extends ShapeData {
    public RectangleData(Shape shape) {
        super(shape);
    }

    public RectangleData() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public RectangleData(double x, double y, double width, double height) {
        super((Shape)new RectangleI(), true);
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public String getText() {
        Rectangle shape = (Rectangle)this.asIObject();
        RString value = shape.getTextValue();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setText(String text) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Rectangle shape = (Rectangle)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setTextValue(rtypes.rstring((String)text));
        this.setDirty(true);
    }

    public double getX() {
        Rectangle shape = (Rectangle)this.asIObject();
        RDouble value = shape.getX();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setX(double x) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Rectangle shape = (Rectangle)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setX(rtypes.rdouble((double)x));
        this.setDirty(true);
    }

    public double getY() {
        Rectangle shape = (Rectangle)this.asIObject();
        RDouble value = shape.getY();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setY(double y) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Rectangle shape = (Rectangle)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setY(rtypes.rdouble((double)y));
        this.setDirty(true);
    }

    public double getWidth() {
        Rectangle shape = (Rectangle)this.asIObject();
        RDouble value = shape.getWidth();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setWidth(double width) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Rectangle shape = (Rectangle)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setWidth(rtypes.rdouble((double)width));
        this.setDirty(true);
    }

    public double getHeight() {
        Rectangle shape = (Rectangle)this.asIObject();
        RDouble value = shape.getHeight();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setHeight(double height) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Rectangle shape = (Rectangle)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setHeight(rtypes.rdouble((double)height));
        this.setDirty(true);
    }
}

