/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.FixedStepHandler;
import org.apache.commons.math.ode.StepHandler;
import org.apache.commons.math.ode.StepInterpolator;

public class StepNormalizer
implements StepHandler {
    private double h;
    private FixedStepHandler handler;
    private double lastTime;
    private double[] lastState;
    private boolean forward;

    public StepNormalizer(double h, FixedStepHandler handler) {
        this.h = Math.abs(h);
        this.handler = handler;
        this.reset();
    }

    public boolean requiresDenseOutput() {
        return true;
    }

    public void reset() {
        this.lastTime = Double.NaN;
        this.lastState = null;
        this.forward = true;
    }

    public void handleStep(StepInterpolator interpolator, boolean isLast) throws DerivativeException {
        double nextTime;
        if (this.lastState == null) {
            this.lastTime = interpolator.getPreviousTime();
            interpolator.setInterpolatedTime(this.lastTime);
            double[] state = interpolator.getInterpolatedState();
            this.lastState = (double[])state.clone();
            boolean bl = this.forward = interpolator.getCurrentTime() >= this.lastTime;
            if (!this.forward) {
                this.h = -this.h;
            }
        }
        boolean nextInStep = this.forward ^ (nextTime = this.lastTime + this.h) > interpolator.getCurrentTime();
        while (nextInStep) {
            this.handler.handleStep(this.lastTime, this.lastState, false);
            this.lastTime = nextTime;
            interpolator.setInterpolatedTime(this.lastTime);
            System.arraycopy(interpolator.getInterpolatedState(), 0, this.lastState, 0, this.lastState.length);
            nextInStep = this.forward ^ (nextTime += this.h) > interpolator.getCurrentTime();
        }
        if (isLast) {
            this.handler.handleStep(this.lastTime, this.lastState, true);
        }
    }
}

