/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public class DescendantTokenCheck
extends Check {
    private int mMinimumDepth;
    private int mMaximumDepth = Integer.MAX_VALUE;
    private int mMinimumNumber;
    private int mMaximumNumber = Integer.MAX_VALUE;
    private int[] mLimitedTokens = new int[0];
    private String mMinimumMessage = "descendant.token.min";
    private String mMaximumMessage = "descendant.token.max";
    private int[] mCounts = new int[0];

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void visitToken(DetailAST aAST) {
        Arrays.fill(this.mCounts, 0);
        this.countTokens((AST)aAST, 0);
        String name = TokenTypes.getTokenName(aAST.getType());
        for (int i = 0; i < this.mLimitedTokens.length; ++i) {
            String descendantName;
            int tokenCount = this.mCounts[this.mLimitedTokens[i] - 1];
            if (tokenCount < this.mMinimumNumber) {
                descendantName = TokenTypes.getTokenName(this.mLimitedTokens[i]);
                this.log(aAST.getLineNo(), aAST.getColumnNo(), this.mMinimumMessage, new String[]{"" + tokenCount, "" + this.mMinimumNumber, name, descendantName});
            }
            if (tokenCount <= this.mMaximumNumber) continue;
            descendantName = TokenTypes.getTokenName(this.mLimitedTokens[i]);
            this.log(aAST.getLineNo(), aAST.getColumnNo(), this.mMaximumMessage, new String[]{"" + tokenCount, "" + this.mMaximumNumber, name, descendantName});
        }
    }

    private void countTokens(AST aAST, int aDepth) {
        if (aDepth <= this.mMaximumDepth) {
            int type;
            if (aDepth >= this.mMinimumDepth && (type = aAST.getType()) <= this.mCounts.length) {
                int n = type - 1;
                this.mCounts[n] = this.mCounts[n] + 1;
            }
            int nextDepth = aDepth + 1;
            for (AST child = aAST.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.countTokens(child, nextDepth);
            }
        }
    }

    public int[] getAcceptableTokens() {
        Set tokenNames = this.getTokenNames();
        int[] result = new int[tokenNames.size()];
        int i = 0;
        Iterator it = tokenNames.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            result[i] = TokenTypes.getTokenId(name);
            ++i;
        }
        return result;
    }

    public void setLimitedTokens(String[] aLimitedTokens) {
        this.mLimitedTokens = new int[aLimitedTokens.length];
        int maxToken = 0;
        for (int i = 0; i < aLimitedTokens.length; ++i) {
            this.mLimitedTokens[i] = TokenTypes.getTokenId(aLimitedTokens[i]);
            if (this.mLimitedTokens[i] <= maxToken) continue;
            maxToken = this.mLimitedTokens[i];
        }
        this.mCounts = new int[maxToken];
    }

    public void setMinimumDepth(int aMinimumDepth) {
        this.mMinimumDepth = aMinimumDepth;
    }

    public void setMaximumDepth(int aMaximumDepth) {
        this.mMaximumDepth = aMaximumDepth;
    }

    public void setMinimumNumber(int aMinimumNumber) {
        this.mMinimumNumber = aMinimumNumber;
    }

    public void setMaximumNumber(int aMaximumNumber) {
        this.mMaximumNumber = aMaximumNumber;
    }

    public void setMinimumMessage(String aMessage) {
        this.mMinimumMessage = aMessage;
    }

    public void setMaximumMessage(String aMessage) {
        this.mMaximumMessage = aMessage;
    }
}

