/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.timer;

import bitronix.tm.timer.TaskException;
import bitronix.tm.timer.TaskScheduler;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Task
implements Comparable<Task> {
    private static final AtomicInteger UNIQUE_ID_SOURCE = new AtomicInteger();
    private final Date executionTime;
    private final TaskScheduler taskScheduler;
    private final int uniqueId;

    protected Task(Date executionTime, TaskScheduler scheduler) {
        this.executionTime = executionTime;
        this.taskScheduler = scheduler;
        this.uniqueId = UNIQUE_ID_SOURCE.getAndIncrement();
    }

    public Date getExecutionTime() {
        return this.executionTime;
    }

    protected TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    @Override
    public int compareTo(Task otherTask) {
        int compareResult = this.executionTime.compareTo(otherTask.executionTime);
        if (compareResult == 0) {
            compareResult = Integer.valueOf(this.uniqueId).compareTo(otherTask.getUniqueId());
        }
        return compareResult;
    }

    public abstract Object getObject();

    public abstract void execute() throws TaskException;

    int getUniqueId() {
        return this.uniqueId;
    }
}

