/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.UpdatableBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.BatchedQueueingProcessor;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.backend.impl.lucene.PerDPResources;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneBackendQueueProcessorFactory
implements UpdatableBackendQueueProcessorFactory {
    private SearchFactoryImplementor searchFactoryImp;
    private volatile Map<DirectoryProvider<?>, PerDPResources> resourcesMap = new HashMap();
    private boolean sync;

    @Override
    public void initialize(Properties props, WorkerBuildContext context) {
        this.searchFactoryImp = context.getUninitializedSearchFactory();
        this.sync = BatchedQueueingProcessor.isConfiguredAsSync(props);
        for (DirectoryProvider<?> dp : context.getDirectoryProviders()) {
            PerDPResources resources = new PerDPResources(context, dp);
            this.resourcesMap.put(dp, resources);
        }
    }

    @Override
    public void updateDirectoryProviders(Set<DirectoryProvider<?>> providers, WorkerBuildContext context) {
        HashMap newResourceMap = new HashMap(this.resourcesMap);
        for (DirectoryProvider<?> provider : providers) {
            if (this.resourcesMap.containsKey(provider)) continue;
            PerDPResources resources = new PerDPResources(context, provider);
            newResourceMap.put(provider, resources);
        }
        for (DirectoryProvider<?> provider : this.resourcesMap.keySet()) {
            if (newResourceMap.containsKey(provider)) continue;
            throw new SearchException("DirectoryProvider no longer present during SearchFactory update");
        }
        this.resourcesMap = newResourceMap;
    }

    @Override
    public Runnable getProcessor(List<LuceneWork> queue) {
        return new LuceneBackendQueueProcessor(queue, this.searchFactoryImp, this.resourcesMap, this.sync);
    }

    @Override
    public void close() {
        for (PerDPResources res : this.resourcesMap.values()) {
            res.shutdown();
        }
    }
}

