/*
 * Decompiled with CFR 0.152.
 */
package ome.model.enums;

import java.util.HashMap;
import java.util.Map;
import ome.model.units.UnitEnum;

public enum UnitsElectricPotential implements UnitEnum
{
    YOTTAVOLT("YV"),
    ZETTAVOLT("ZV"),
    EXAVOLT("EV"),
    PETAVOLT("PV"),
    TERAVOLT("TV"),
    GIGAVOLT("GV"),
    MEGAVOLT("MV"),
    KILOVOLT("kV"),
    HECTOVOLT("hV"),
    DECAVOLT("daV"),
    VOLT("V"),
    DECIVOLT("dV"),
    CENTIVOLT("cV"),
    MILLIVOLT("mV"),
    MICROVOLT("\u00b5V"),
    NANOVOLT("nV"),
    PICOVOLT("pV"),
    FEMTOVOLT("fV"),
    ATTOVOLT("aV"),
    ZEPTOVOLT("zV"),
    YOCTOVOLT("yV");

    private static final Map<String, UnitsElectricPotential> bySymbol;
    protected String symbol;

    private UnitsElectricPotential(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public static UnitsElectricPotential bySymbol(String symbol) {
        return bySymbol.get(symbol);
    }

    static {
        bySymbol = new HashMap<String, UnitsElectricPotential>();
        for (UnitsElectricPotential t : UnitsElectricPotential.values()) {
            bySymbol.put(t.symbol, t);
        }
    }
}

