/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import org.hibernate.cache.jbc.entity.TransactionalAccess;
import org.hibernate.cache.jbc.util.CircumventChecksDataVersion;
import org.hibernate.cache.jbc.util.NonLockingDataVersion;
import org.hibernate.util.CalendarComparator;
import org.hibernate.util.ComparableComparator;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataVersionAdapter
implements DataVersion {
    private static final Logger log = LoggerFactory.getLogger(TransactionalAccess.class);
    private static final long serialVersionUID = 5564692336076405571L;
    private final Object currentVersion;
    private final Object previousVersion;
    private transient Comparator versionComparator;
    private final String sourceIdentifer;

    public DataVersionAdapter(Object currentVersion, Object previousVersion, Comparator versionComparator, String sourceIdentifer) {
        this.currentVersion = currentVersion;
        this.previousVersion = previousVersion;
        this.versionComparator = versionComparator;
        this.sourceIdentifer = sourceIdentifer;
        log.trace("created " + this);
    }

    public boolean newerThan(DataVersion dataVersion) {
        log.trace("checking [" + this + "] against [" + dataVersion + "]");
        if (dataVersion instanceof CircumventChecksDataVersion) {
            log.trace("skipping lock checks...");
            return false;
        }
        if (dataVersion instanceof NonLockingDataVersion) {
            log.trace("skipping lock checks...");
            return false;
        }
        if (dataVersion instanceof DefaultDataVersion) {
            if (((DefaultDataVersion)dataVersion).getRawVersion() > 1L) {
                log.warn("Unexpected comparison to " + dataVersion + " -- we are " + this.toString());
            }
            return true;
        }
        DataVersionAdapter other = (DataVersionAdapter)dataVersion;
        if (other.previousVersion == null) {
            log.warn("Unexpected optimistic lock check on inserting data");
            if (this == dataVersion) {
                log.trace("skipping lock checks due to same DV instance");
                return false;
            }
        }
        if (this.currentVersion == null) {
            return other.previousVersion != null;
        }
        if (this == dataVersion) {
            return false;
        }
        return this.versionComparator.compare(this.currentVersion, other.previousVersion) >= 1;
    }

    public String toString() {
        return super.toString() + " [current=" + this.currentVersion + ", previous=" + this.previousVersion + ", src=" + this.sourceIdentifer + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.versionComparator instanceof ComparableComparator) {
            out.writeByte(0);
        } else if (this.versionComparator instanceof CalendarComparator) {
            out.writeByte(1);
        } else {
            out.writeByte(999);
            out.writeObject(this.versionComparator);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte comparatorType = in.readByte();
        switch (comparatorType) {
            case 0: {
                this.versionComparator = ComparableComparator.INSTANCE;
                break;
            }
            case 1: {
                this.versionComparator = CalendarComparator.INSTANCE;
                break;
            }
            default: {
                this.versionComparator = (Comparator)in.readObject();
            }
        }
    }
}

