/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.io;

import java.io.IOException;
import java.io.OutputStream;

public abstract class ThresholdingOutputStream
extends OutputStream {
    protected OutputStream output;
    int threshold;
    int written = 0;
    boolean thresholdReached = false;

    public ThresholdingOutputStream(OutputStream base, int thresholdBytes) {
        this.output = base;
        this.threshold = thresholdBytes;
    }

    public void close() throws IOException {
        this.output.close();
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkThreshold(len);
        this.output.write(b, off, len);
        this.written += len;
    }

    public void write(byte[] b) throws IOException {
        this.checkThreshold(b.length);
        this.output.write(b);
        this.written += b.length;
    }

    public void write(int b) throws IOException {
        this.checkThreshold(1);
        this.output.write(b);
        ++this.written;
    }

    protected void checkThreshold(int count) throws IOException {
        int predicted = this.written + count;
        if (!this.thresholdReached && predicted > this.threshold) {
            this.thresholdReached(this.written, predicted);
            this.thresholdReached = true;
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    protected abstract void thresholdReached(int var1, int var2) throws IOException;
}

