/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;
import ome.security.ACLVoter;
import ome.security.basic.LightAdminPrivileges;
import ome.services.delete.Deletion;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphPolicyRule;
import ome.system.Roles;
import omero.cmd.GraphModify2;
import omero.cmd.GraphQuery;
import omero.cmd.Request;
import omero.cmd.SkipHead;
import omero.cmd.graphs.Chgrp2I;
import omero.cmd.graphs.ChildOption;
import omero.cmd.graphs.ChildOptionI;
import omero.cmd.graphs.Chown2I;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GraphRequestFactory
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphRequestFactory.class);
    private final ACLVoter aclVoter;
    private final Roles securityRoles;
    private final GraphPathBean graphPathBean;
    private final LightAdminPrivileges adminPrivileges;
    private final Deletion deletionInstance;
    private final ImmutableSetMultimap<Class<? extends Request>, Class<? extends IObject>> allTargets;
    private final ImmutableMap<Class<? extends Request>, GraphPolicy> graphPolicies;
    private final ImmutableSetMultimap<String, String> unnullable;
    private final ImmutableSet<String> defaultExcludeNs;
    private ApplicationContext applicationContext = null;

    public GraphRequestFactory(ACLVoter aclVoter, Roles securityRoles, GraphPathBean graphPathBean, LightAdminPrivileges adminPrivileges, Deletion deletionInstance, Map<Class<? extends Request>, List<String>> allTargets, Map<Class<? extends Request>, List<GraphPolicyRule>> allRules, List<String> unnullable, Set<String> defaultExcludeNs) throws GraphException {
        this.aclVoter = aclVoter;
        this.securityRoles = securityRoles;
        this.graphPathBean = graphPathBean;
        this.adminPrivileges = adminPrivileges;
        this.deletionInstance = deletionInstance;
        ImmutableSetMultimap.Builder allTargetsBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry<Class<? extends Request>, List<String>> entry : allTargets.entrySet()) {
            Class<? extends Request> clazz = entry.getKey();
            for (String targetClassName : entry.getValue()) {
                allTargetsBuilder.put(clazz, (Object)graphPathBean.getClassForSimpleName(targetClassName));
            }
        }
        this.allTargets = allTargetsBuilder.build();
        aclVoter.setPermittedClasses((Map)ImmutableMap.of((Object)4, (Object)this.allTargets.get(Chgrp2I.class), (Object)5, (Object)this.allTargets.get(Chown2I.class)));
        ImmutableMap.Builder graphPoliciesBuilder = ImmutableMap.builder();
        for (Map.Entry<Class<? extends Request>, List<GraphPolicyRule>> entry : allRules.entrySet()) {
            graphPoliciesBuilder.put(entry.getKey(), (Object)GraphPolicyRule.parseRules((GraphPathBean)graphPathBean, (Collection)entry.getValue()));
        }
        this.graphPolicies = graphPoliciesBuilder.build();
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (String classProperty : unnullable) {
            int period = classProperty.indexOf(46);
            String classNameSimple = classProperty.substring(0, period);
            String property = classProperty.substring(period + 1);
            String classNameFull = graphPathBean.getClassForSimpleName(classNameSimple).getName();
            builder.put((Object)classNameFull, (Object)property);
        }
        this.unnullable = builder.build();
        this.defaultExcludeNs = ImmutableSet.copyOf(defaultExcludeNs);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public GraphPathBean getGraphPathBean() {
        return this.graphPathBean;
    }

    public <R extends GraphQuery> Set<Class<? extends IObject>> getLegalTargets(Class<R> requestClass) {
        ImmutableSet targetClasses = this.allTargets.get(requestClass);
        if (targetClasses.isEmpty()) {
            throw new IllegalArgumentException("no legal target classes defined for request class " + requestClass);
        }
        return targetClasses;
    }

    public <R extends GraphQuery> R getRequest(Class<R> requestClass) {
        GraphQuery request;
        try {
            if (SkipHead.class.isAssignableFrom(requestClass)) {
                Constructor<R> constructor = requestClass.getConstructor(GraphPathBean.class, GraphRequestFactory.class);
                request = (GraphQuery)((Object)constructor.newInstance(this.graphPathBean, this));
            } else {
                Set<Class<IObject>> targetClasses = this.getLegalTargets(requestClass);
                GraphPolicy graphPolicy = (GraphPolicy)this.graphPolicies.get(requestClass);
                if (graphPolicy == null) {
                    throw new IllegalArgumentException("no graph traversal policy rules defined for request class " + requestClass);
                }
                graphPolicy = graphPolicy.getCleanInstance();
                if (GraphModify2.class.isAssignableFrom(requestClass)) {
                    Constructor<R> constructor = requestClass.getConstructor(ACLVoter.class, Roles.class, GraphPathBean.class, LightAdminPrivileges.class, Deletion.class, Set.class, GraphPolicy.class, SetMultimap.class, ApplicationContext.class);
                    request = (GraphQuery)((Object)constructor.newInstance(this.aclVoter, this.securityRoles, this.graphPathBean, this.adminPrivileges, this.deletionInstance, targetClasses, graphPolicy, this.unnullable, this.applicationContext));
                } else {
                    Constructor<R> constructor = requestClass.getConstructor(ACLVoter.class, Roles.class, GraphPathBean.class, LightAdminPrivileges.class, Set.class, GraphPolicy.class);
                    request = (GraphQuery)((Object)constructor.newInstance(this.aclVoter, this.securityRoles, this.graphPathBean, this.adminPrivileges, targetClasses, graphPolicy));
                }
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new IllegalArgumentException("cannot instantiate " + requestClass, e);
        }
        return (R)((Object)request);
    }

    public ChildOption createChildOption() {
        return new ChildOptionI(this.graphPathBean, this.defaultExcludeNs);
    }
}

