/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.FormatType;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import IceInternal.BasicStream;
import IceInternal.Ex;
import IceInternal.Incoming;
import java.util.Arrays;
import java.util.List;
import omero.RDouble;
import omero.RDoubleHolder;
import omero.RInt;
import omero.RIntHolder;
import omero.RLong;
import omero.RString;
import omero.RStringHolder;
import omero.model.AcquisitionMode;
import omero.model.AcquisitionModeHolder;
import omero.model.Channel;
import omero.model.ChannelHolder;
import omero.model.ContrastMethod;
import omero.model.ContrastMethodHolder;
import omero.model.Details;
import omero.model.DetectorSettings;
import omero.model.DetectorSettingsHolder;
import omero.model.FilterSet;
import omero.model.FilterSetHolder;
import omero.model.IObject;
import omero.model.Illumination;
import omero.model.IlluminationHolder;
import omero.model.Length;
import omero.model.LengthHolder;
import omero.model.LightPath;
import omero.model.LightPathHolder;
import omero.model.LightSettings;
import omero.model.LightSettingsHolder;
import omero.model.LogicalChannelChannelsSeqHelper;
import omero.model.LogicalChannelHolder;
import omero.model.OTF;
import omero.model.OTFHolder;
import omero.model.PhotometricInterpretation;
import omero.model.PhotometricInterpretationHolder;
import omero.model._LogicalChannelOperations;
import omero.model._LogicalChannelOperationsNC;

public abstract class LogicalChannel
extends IObject
implements _LogicalChannelOperations,
_LogicalChannelOperationsNC {
    public static final String[] __ids = new String[]{"::Ice::Object", "::omero::model::IObject", "::omero::model::LogicalChannel"};
    private static final String[] __all = new String[]{"addAllChannelSet", "addChannel", "clearChannels", "copyChannels", "getContrastMethod", "getDetails", "getDetectorSettings", "getEmissionWave", "getExcitationWave", "getFilterSet", "getFluor", "getId", "getIllumination", "getLightPath", "getLightSourceSettings", "getMode", "getName", "getNdFilter", "getOtf", "getPhotometricInterpretation", "getPinHoleSize", "getPockelCellSetting", "getSamplesPerPixel", "getVersion", "ice_id", "ice_ids", "ice_isA", "ice_ping", "isAnnotated", "isGlobal", "isLink", "isLoaded", "isMutable", "proxy", "reloadChannels", "removeAllChannelSet", "removeChannel", "setContrastMethod", "setDetectorSettings", "setEmissionWave", "setExcitationWave", "setFilterSet", "setFluor", "setId", "setIllumination", "setLightPath", "setLightSourceSettings", "setMode", "setName", "setNdFilter", "setOtf", "setPhotometricInterpretation", "setPinHoleSize", "setPockelCellSetting", "setSamplesPerPixel", "setVersion", "shallowCopy", "sizeOfChannels", "unload", "unloadChannels", "unloadCollections", "unloadDetails"};
    protected RInt version;
    protected RString name;
    protected Length pinHoleSize;
    protected Illumination illumination;
    protected ContrastMethod contrastMethod;
    protected Length excitationWave;
    protected Length emissionWave;
    protected RString fluor;
    protected RDouble ndFilter;
    protected OTF otf;
    protected DetectorSettings detectorSettings;
    protected LightSettings lightSourceSettings;
    protected FilterSet filterSet;
    protected RInt samplesPerPixel;
    protected PhotometricInterpretation photometricInterpretation;
    protected AcquisitionMode mode;
    protected RInt pockelCellSetting;
    protected List<Channel> channelsSeq;
    protected boolean channelsLoaded;
    protected LightPath lightPath;
    public static final long serialVersionUID = -804413041584667611L;

    public LogicalChannel() {
    }

    public LogicalChannel(RLong id, Details details, boolean loaded, RInt version, RString name, Length pinHoleSize, Illumination illumination, ContrastMethod contrastMethod, Length excitationWave, Length emissionWave, RString fluor, RDouble ndFilter, OTF otf, DetectorSettings detectorSettings, LightSettings lightSourceSettings, FilterSet filterSet, RInt samplesPerPixel, PhotometricInterpretation photometricInterpretation, AcquisitionMode mode, RInt pockelCellSetting, List<Channel> channelsSeq, boolean channelsLoaded, LightPath lightPath) {
        super(id, details, loaded);
        this.version = version;
        this.name = name;
        this.pinHoleSize = pinHoleSize;
        this.illumination = illumination;
        this.contrastMethod = contrastMethod;
        this.excitationWave = excitationWave;
        this.emissionWave = emissionWave;
        this.fluor = fluor;
        this.ndFilter = ndFilter;
        this.otf = otf;
        this.detectorSettings = detectorSettings;
        this.lightSourceSettings = lightSourceSettings;
        this.filterSet = filterSet;
        this.samplesPerPixel = samplesPerPixel;
        this.photometricInterpretation = photometricInterpretation;
        this.mode = mode;
        this.pockelCellSetting = pockelCellSetting;
        this.channelsSeq = channelsSeq;
        this.channelsLoaded = channelsLoaded;
        this.lightPath = lightPath;
    }

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return __ids;
    }

    @Override
    public String[] ice_ids(Current __current) {
        return __ids;
    }

    @Override
    public String ice_id() {
        return __ids[2];
    }

    @Override
    public String ice_id(Current __current) {
        return __ids[2];
    }

    public static String ice_staticId() {
        return __ids[2];
    }

    @Override
    public final void addAllChannelSet(List<Channel> targets) {
        this.addAllChannelSet(targets, null);
    }

    @Override
    public final void addChannel(Channel target) {
        this.addChannel(target, null);
    }

    @Override
    public final void clearChannels() {
        this.clearChannels(null);
    }

    @Override
    public final List<Channel> copyChannels() {
        return this.copyChannels(null);
    }

    @Override
    public final ContrastMethod getContrastMethod() {
        return this.getContrastMethod(null);
    }

    @Override
    public final DetectorSettings getDetectorSettings() {
        return this.getDetectorSettings(null);
    }

    @Override
    public final Length getEmissionWave() {
        return this.getEmissionWave(null);
    }

    @Override
    public final Length getExcitationWave() {
        return this.getExcitationWave(null);
    }

    @Override
    public final FilterSet getFilterSet() {
        return this.getFilterSet(null);
    }

    @Override
    public final RString getFluor() {
        return this.getFluor(null);
    }

    @Override
    public final Illumination getIllumination() {
        return this.getIllumination(null);
    }

    @Override
    public final LightPath getLightPath() {
        return this.getLightPath(null);
    }

    @Override
    public final LightSettings getLightSourceSettings() {
        return this.getLightSourceSettings(null);
    }

    @Override
    public final AcquisitionMode getMode() {
        return this.getMode(null);
    }

    @Override
    public final RString getName() {
        return this.getName(null);
    }

    @Override
    public final RDouble getNdFilter() {
        return this.getNdFilter(null);
    }

    @Override
    public final OTF getOtf() {
        return this.getOtf(null);
    }

    @Override
    public final PhotometricInterpretation getPhotometricInterpretation() {
        return this.getPhotometricInterpretation(null);
    }

    @Override
    public final Length getPinHoleSize() {
        return this.getPinHoleSize(null);
    }

    @Override
    public final RInt getPockelCellSetting() {
        return this.getPockelCellSetting(null);
    }

    @Override
    public final RInt getSamplesPerPixel() {
        return this.getSamplesPerPixel(null);
    }

    @Override
    public final RInt getVersion() {
        return this.getVersion(null);
    }

    @Override
    public final void reloadChannels(LogicalChannel toCopy) {
        this.reloadChannels(toCopy, null);
    }

    @Override
    public final void removeAllChannelSet(List<Channel> targets) {
        this.removeAllChannelSet(targets, null);
    }

    @Override
    public final void removeChannel(Channel theTarget) {
        this.removeChannel(theTarget, null);
    }

    @Override
    public final void setContrastMethod(ContrastMethod theContrastMethod) {
        this.setContrastMethod(theContrastMethod, null);
    }

    @Override
    public final void setDetectorSettings(DetectorSettings theDetectorSettings) {
        this.setDetectorSettings(theDetectorSettings, null);
    }

    @Override
    public final void setEmissionWave(Length theEmissionWave) {
        this.setEmissionWave(theEmissionWave, null);
    }

    @Override
    public final void setExcitationWave(Length theExcitationWave) {
        this.setExcitationWave(theExcitationWave, null);
    }

    @Override
    public final void setFilterSet(FilterSet theFilterSet) {
        this.setFilterSet(theFilterSet, null);
    }

    @Override
    public final void setFluor(RString theFluor) {
        this.setFluor(theFluor, null);
    }

    @Override
    public final void setIllumination(Illumination theIllumination) {
        this.setIllumination(theIllumination, null);
    }

    @Override
    public final void setLightPath(LightPath theLightPath) {
        this.setLightPath(theLightPath, null);
    }

    @Override
    public final void setLightSourceSettings(LightSettings theLightSourceSettings) {
        this.setLightSourceSettings(theLightSourceSettings, null);
    }

    @Override
    public final void setMode(AcquisitionMode theMode) {
        this.setMode(theMode, null);
    }

    @Override
    public final void setName(RString theName) {
        this.setName(theName, null);
    }

    @Override
    public final void setNdFilter(RDouble theNdFilter) {
        this.setNdFilter(theNdFilter, null);
    }

    @Override
    public final void setOtf(OTF theOtf) {
        this.setOtf(theOtf, null);
    }

    @Override
    public final void setPhotometricInterpretation(PhotometricInterpretation thePhotometricInterpretation) {
        this.setPhotometricInterpretation(thePhotometricInterpretation, null);
    }

    @Override
    public final void setPinHoleSize(Length thePinHoleSize) {
        this.setPinHoleSize(thePinHoleSize, null);
    }

    @Override
    public final void setPockelCellSetting(RInt thePockelCellSetting) {
        this.setPockelCellSetting(thePockelCellSetting, null);
    }

    @Override
    public final void setSamplesPerPixel(RInt theSamplesPerPixel) {
        this.setSamplesPerPixel(theSamplesPerPixel, null);
    }

    @Override
    public final void setVersion(RInt theVersion) {
        this.setVersion(theVersion, null);
    }

    @Override
    public final int sizeOfChannels() {
        return this.sizeOfChannels(null);
    }

    @Override
    public final void unloadChannels() {
        this.unloadChannels(null);
    }

    public static DispatchStatus ___getVersion(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RInt __ret = __obj.getVersion(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setVersion(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RIntHolder theVersion = new RIntHolder();
        __is.readObject((IceInternal.Patcher)theVersion);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setVersion((RInt)theVersion.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getName(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getName(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setName(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theName = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theName);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setName((RString)theName.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getPinHoleSize(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Length __ret = __obj.getPinHoleSize(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setPinHoleSize(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        LengthHolder thePinHoleSize = new LengthHolder();
        __is.readObject((IceInternal.Patcher)thePinHoleSize);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setPinHoleSize((Length)thePinHoleSize.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getIllumination(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Illumination __ret = __obj.getIllumination(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setIllumination(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        IlluminationHolder theIllumination = new IlluminationHolder();
        __is.readObject((IceInternal.Patcher)theIllumination);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setIllumination((Illumination)theIllumination.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getContrastMethod(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        ContrastMethod __ret = __obj.getContrastMethod(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setContrastMethod(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        ContrastMethodHolder theContrastMethod = new ContrastMethodHolder();
        __is.readObject((IceInternal.Patcher)theContrastMethod);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setContrastMethod((ContrastMethod)theContrastMethod.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getExcitationWave(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Length __ret = __obj.getExcitationWave(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setExcitationWave(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        LengthHolder theExcitationWave = new LengthHolder();
        __is.readObject((IceInternal.Patcher)theExcitationWave);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setExcitationWave((Length)theExcitationWave.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getEmissionWave(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Length __ret = __obj.getEmissionWave(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setEmissionWave(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        LengthHolder theEmissionWave = new LengthHolder();
        __is.readObject((IceInternal.Patcher)theEmissionWave);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setEmissionWave((Length)theEmissionWave.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getFluor(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getFluor(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setFluor(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theFluor = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theFluor);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setFluor((RString)theFluor.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getNdFilter(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RDouble __ret = __obj.getNdFilter(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setNdFilter(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RDoubleHolder theNdFilter = new RDoubleHolder();
        __is.readObject((IceInternal.Patcher)theNdFilter);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setNdFilter((RDouble)theNdFilter.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getOtf(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        OTF __ret = __obj.getOtf(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setOtf(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        OTFHolder theOtf = new OTFHolder();
        __is.readObject((IceInternal.Patcher)theOtf);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setOtf((OTF)theOtf.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getDetectorSettings(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        DetectorSettings __ret = __obj.getDetectorSettings(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setDetectorSettings(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        DetectorSettingsHolder theDetectorSettings = new DetectorSettingsHolder();
        __is.readObject((IceInternal.Patcher)theDetectorSettings);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setDetectorSettings((DetectorSettings)theDetectorSettings.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getLightSourceSettings(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        LightSettings __ret = __obj.getLightSourceSettings(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setLightSourceSettings(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        LightSettingsHolder theLightSourceSettings = new LightSettingsHolder();
        __is.readObject((IceInternal.Patcher)theLightSourceSettings);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setLightSourceSettings((LightSettings)theLightSourceSettings.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getFilterSet(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        FilterSet __ret = __obj.getFilterSet(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setFilterSet(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetHolder theFilterSet = new FilterSetHolder();
        __is.readObject((IceInternal.Patcher)theFilterSet);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setFilterSet((FilterSet)theFilterSet.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getSamplesPerPixel(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RInt __ret = __obj.getSamplesPerPixel(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setSamplesPerPixel(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RIntHolder theSamplesPerPixel = new RIntHolder();
        __is.readObject((IceInternal.Patcher)theSamplesPerPixel);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setSamplesPerPixel((RInt)theSamplesPerPixel.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getPhotometricInterpretation(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        PhotometricInterpretation __ret = __obj.getPhotometricInterpretation(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setPhotometricInterpretation(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        PhotometricInterpretationHolder thePhotometricInterpretation = new PhotometricInterpretationHolder();
        __is.readObject((IceInternal.Patcher)thePhotometricInterpretation);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setPhotometricInterpretation((PhotometricInterpretation)thePhotometricInterpretation.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getMode(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        AcquisitionMode __ret = __obj.getMode(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setMode(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        AcquisitionModeHolder theMode = new AcquisitionModeHolder();
        __is.readObject((IceInternal.Patcher)theMode);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setMode((AcquisitionMode)theMode.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getPockelCellSetting(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RInt __ret = __obj.getPockelCellSetting(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setPockelCellSetting(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RIntHolder thePockelCellSetting = new RIntHolder();
        __is.readObject((IceInternal.Patcher)thePockelCellSetting);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setPockelCellSetting((RInt)thePockelCellSetting.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadChannels(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.unloadChannels(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfChannels(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfChannels(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyChannels(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        List __ret = __obj.copyChannels(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        LogicalChannelChannelsSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addChannel(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        ChannelHolder target = new ChannelHolder();
        __is.readObject((IceInternal.Patcher)target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addChannel((Channel)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllChannelSet(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<Channel> targets = LogicalChannelChannelsSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllChannelSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeChannel(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        ChannelHolder theTarget = new ChannelHolder();
        __is.readObject((IceInternal.Patcher)theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeChannel((Channel)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllChannelSet(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<Channel> targets = LogicalChannelChannelsSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllChannelSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearChannels(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.clearChannels(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadChannels(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        LogicalChannelHolder toCopy = new LogicalChannelHolder();
        __is.readObject((IceInternal.Patcher)toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadChannels((LogicalChannel)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getLightPath(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        LightPath __ret = __obj.getLightPath(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setLightPath(LogicalChannel __obj, Incoming __inS, Current __current) {
        LogicalChannel.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        LightPathHolder theLightPath = new LightPathHolder();
        __is.readObject((IceInternal.Patcher)theLightPath);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setLightPath((LightPath)theLightPath.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    @Override
    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return LogicalChannel.___addAllChannelSet(this, in, __current);
            }
            case 1: {
                return LogicalChannel.___addChannel(this, in, __current);
            }
            case 2: {
                return LogicalChannel.___clearChannels(this, in, __current);
            }
            case 3: {
                return LogicalChannel.___copyChannels(this, in, __current);
            }
            case 4: {
                return LogicalChannel.___getContrastMethod(this, in, __current);
            }
            case 5: {
                return IObject.___getDetails(this, in, __current);
            }
            case 6: {
                return LogicalChannel.___getDetectorSettings(this, in, __current);
            }
            case 7: {
                return LogicalChannel.___getEmissionWave(this, in, __current);
            }
            case 8: {
                return LogicalChannel.___getExcitationWave(this, in, __current);
            }
            case 9: {
                return LogicalChannel.___getFilterSet(this, in, __current);
            }
            case 10: {
                return LogicalChannel.___getFluor(this, in, __current);
            }
            case 11: {
                return IObject.___getId(this, in, __current);
            }
            case 12: {
                return LogicalChannel.___getIllumination(this, in, __current);
            }
            case 13: {
                return LogicalChannel.___getLightPath(this, in, __current);
            }
            case 14: {
                return LogicalChannel.___getLightSourceSettings(this, in, __current);
            }
            case 15: {
                return LogicalChannel.___getMode(this, in, __current);
            }
            case 16: {
                return LogicalChannel.___getName(this, in, __current);
            }
            case 17: {
                return LogicalChannel.___getNdFilter(this, in, __current);
            }
            case 18: {
                return LogicalChannel.___getOtf(this, in, __current);
            }
            case 19: {
                return LogicalChannel.___getPhotometricInterpretation(this, in, __current);
            }
            case 20: {
                return LogicalChannel.___getPinHoleSize(this, in, __current);
            }
            case 21: {
                return LogicalChannel.___getPockelCellSetting(this, in, __current);
            }
            case 22: {
                return LogicalChannel.___getSamplesPerPixel(this, in, __current);
            }
            case 23: {
                return LogicalChannel.___getVersion(this, in, __current);
            }
            case 24: {
                return LogicalChannel.___ice_id((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 25: {
                return LogicalChannel.___ice_ids((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 26: {
                return LogicalChannel.___ice_isA((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 27: {
                return LogicalChannel.___ice_ping((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 28: {
                return IObject.___isAnnotated(this, in, __current);
            }
            case 29: {
                return IObject.___isGlobal(this, in, __current);
            }
            case 30: {
                return IObject.___isLink(this, in, __current);
            }
            case 31: {
                return IObject.___isLoaded(this, in, __current);
            }
            case 32: {
                return IObject.___isMutable(this, in, __current);
            }
            case 33: {
                return IObject.___proxy(this, in, __current);
            }
            case 34: {
                return LogicalChannel.___reloadChannels(this, in, __current);
            }
            case 35: {
                return LogicalChannel.___removeAllChannelSet(this, in, __current);
            }
            case 36: {
                return LogicalChannel.___removeChannel(this, in, __current);
            }
            case 37: {
                return LogicalChannel.___setContrastMethod(this, in, __current);
            }
            case 38: {
                return LogicalChannel.___setDetectorSettings(this, in, __current);
            }
            case 39: {
                return LogicalChannel.___setEmissionWave(this, in, __current);
            }
            case 40: {
                return LogicalChannel.___setExcitationWave(this, in, __current);
            }
            case 41: {
                return LogicalChannel.___setFilterSet(this, in, __current);
            }
            case 42: {
                return LogicalChannel.___setFluor(this, in, __current);
            }
            case 43: {
                return IObject.___setId(this, in, __current);
            }
            case 44: {
                return LogicalChannel.___setIllumination(this, in, __current);
            }
            case 45: {
                return LogicalChannel.___setLightPath(this, in, __current);
            }
            case 46: {
                return LogicalChannel.___setLightSourceSettings(this, in, __current);
            }
            case 47: {
                return LogicalChannel.___setMode(this, in, __current);
            }
            case 48: {
                return LogicalChannel.___setName(this, in, __current);
            }
            case 49: {
                return LogicalChannel.___setNdFilter(this, in, __current);
            }
            case 50: {
                return LogicalChannel.___setOtf(this, in, __current);
            }
            case 51: {
                return LogicalChannel.___setPhotometricInterpretation(this, in, __current);
            }
            case 52: {
                return LogicalChannel.___setPinHoleSize(this, in, __current);
            }
            case 53: {
                return LogicalChannel.___setPockelCellSetting(this, in, __current);
            }
            case 54: {
                return LogicalChannel.___setSamplesPerPixel(this, in, __current);
            }
            case 55: {
                return LogicalChannel.___setVersion(this, in, __current);
            }
            case 56: {
                return IObject.___shallowCopy(this, in, __current);
            }
            case 57: {
                return LogicalChannel.___sizeOfChannels(this, in, __current);
            }
            case 58: {
                return IObject.___unload(this, in, __current);
            }
            case 59: {
                return LogicalChannel.___unloadChannels(this, in, __current);
            }
            case 60: {
                return IObject.___unloadCollections(this, in, __current);
            }
            case 61: {
                return IObject.___unloadDetails(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    @Override
    protected void __writeImpl(BasicStream __os) {
        __os.startWriteSlice(LogicalChannel.ice_staticId(), -1, false);
        __os.writeObject((Ice.Object)this.version);
        __os.writeObject((Ice.Object)this.name);
        __os.writeObject((Ice.Object)this.pinHoleSize);
        __os.writeObject((Ice.Object)this.illumination);
        __os.writeObject((Ice.Object)this.contrastMethod);
        __os.writeObject((Ice.Object)this.excitationWave);
        __os.writeObject((Ice.Object)this.emissionWave);
        __os.writeObject((Ice.Object)this.fluor);
        __os.writeObject((Ice.Object)this.ndFilter);
        __os.writeObject((Ice.Object)this.otf);
        __os.writeObject((Ice.Object)this.detectorSettings);
        __os.writeObject((Ice.Object)this.lightSourceSettings);
        __os.writeObject((Ice.Object)this.filterSet);
        __os.writeObject((Ice.Object)this.samplesPerPixel);
        __os.writeObject((Ice.Object)this.photometricInterpretation);
        __os.writeObject((Ice.Object)this.mode);
        __os.writeObject((Ice.Object)this.pockelCellSetting);
        LogicalChannelChannelsSeqHelper.write(__os, this.channelsSeq);
        __os.writeBool(this.channelsLoaded);
        __os.writeObject((Ice.Object)this.lightPath);
        __os.endWriteSlice();
        super.__writeImpl(__os);
    }

    @Override
    protected void __readImpl(BasicStream __is) {
        __is.startReadSlice();
        __is.readObject((IceInternal.Patcher)new Patcher(0));
        __is.readObject((IceInternal.Patcher)new Patcher(1));
        __is.readObject((IceInternal.Patcher)new Patcher(2));
        __is.readObject((IceInternal.Patcher)new Patcher(3));
        __is.readObject((IceInternal.Patcher)new Patcher(4));
        __is.readObject((IceInternal.Patcher)new Patcher(5));
        __is.readObject((IceInternal.Patcher)new Patcher(6));
        __is.readObject((IceInternal.Patcher)new Patcher(7));
        __is.readObject((IceInternal.Patcher)new Patcher(8));
        __is.readObject((IceInternal.Patcher)new Patcher(9));
        __is.readObject((IceInternal.Patcher)new Patcher(10));
        __is.readObject((IceInternal.Patcher)new Patcher(11));
        __is.readObject((IceInternal.Patcher)new Patcher(12));
        __is.readObject((IceInternal.Patcher)new Patcher(13));
        __is.readObject((IceInternal.Patcher)new Patcher(14));
        __is.readObject((IceInternal.Patcher)new Patcher(15));
        __is.readObject((IceInternal.Patcher)new Patcher(16));
        this.channelsSeq = LogicalChannelChannelsSeqHelper.read(__is);
        this.channelsLoaded = __is.readBool();
        __is.readObject((IceInternal.Patcher)new Patcher(17));
        __is.endReadSlice();
        super.__readImpl(__is);
    }

    @Override
    public LogicalChannel clone() {
        return (LogicalChannel)super.clone();
    }

    private class Patcher
    implements IceInternal.Patcher {
        private int __member;
        private String __typeId;

        Patcher(int member) {
            this.__member = member;
        }

        public void patch(Ice.Object v) {
            switch (this.__member) {
                case 0: {
                    this.__typeId = "::omero::RInt";
                    if (v == null || v instanceof RInt) {
                        LogicalChannel.this.version = (RInt)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 1: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        LogicalChannel.this.name = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 2: {
                    this.__typeId = "::omero::model::Length";
                    if (v == null || v instanceof Length) {
                        LogicalChannel.this.pinHoleSize = (Length)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 3: {
                    this.__typeId = "::omero::model::Illumination";
                    if (v == null || v instanceof Illumination) {
                        LogicalChannel.this.illumination = (Illumination)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 4: {
                    this.__typeId = "::omero::model::ContrastMethod";
                    if (v == null || v instanceof ContrastMethod) {
                        LogicalChannel.this.contrastMethod = (ContrastMethod)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 5: {
                    this.__typeId = "::omero::model::Length";
                    if (v == null || v instanceof Length) {
                        LogicalChannel.this.excitationWave = (Length)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 6: {
                    this.__typeId = "::omero::model::Length";
                    if (v == null || v instanceof Length) {
                        LogicalChannel.this.emissionWave = (Length)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 7: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        LogicalChannel.this.fluor = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 8: {
                    this.__typeId = "::omero::RDouble";
                    if (v == null || v instanceof RDouble) {
                        LogicalChannel.this.ndFilter = (RDouble)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 9: {
                    this.__typeId = "::omero::model::OTF";
                    if (v == null || v instanceof OTF) {
                        LogicalChannel.this.otf = (OTF)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 10: {
                    this.__typeId = "::omero::model::DetectorSettings";
                    if (v == null || v instanceof DetectorSettings) {
                        LogicalChannel.this.detectorSettings = (DetectorSettings)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 11: {
                    this.__typeId = "::omero::model::LightSettings";
                    if (v == null || v instanceof LightSettings) {
                        LogicalChannel.this.lightSourceSettings = (LightSettings)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 12: {
                    this.__typeId = "::omero::model::FilterSet";
                    if (v == null || v instanceof FilterSet) {
                        LogicalChannel.this.filterSet = (FilterSet)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 13: {
                    this.__typeId = "::omero::RInt";
                    if (v == null || v instanceof RInt) {
                        LogicalChannel.this.samplesPerPixel = (RInt)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 14: {
                    this.__typeId = "::omero::model::PhotometricInterpretation";
                    if (v == null || v instanceof PhotometricInterpretation) {
                        LogicalChannel.this.photometricInterpretation = (PhotometricInterpretation)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 15: {
                    this.__typeId = "::omero::model::AcquisitionMode";
                    if (v == null || v instanceof AcquisitionMode) {
                        LogicalChannel.this.mode = (AcquisitionMode)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 16: {
                    this.__typeId = "::omero::RInt";
                    if (v == null || v instanceof RInt) {
                        LogicalChannel.this.pockelCellSetting = (RInt)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 17: {
                    this.__typeId = "::omero::model::LightPath";
                    if (v == null || v instanceof LightPath) {
                        LogicalChannel.this.lightPath = (LightPath)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                }
            }
        }

        public String type() {
            return this.__typeId;
        }
    }
}

