/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import loci.common.enumeration.CodedEnum;
import loci.common.enumeration.EnumException;
import loci.formats.FormatException;
import loci.formats.tiff.TiffRational;

public enum IFDType implements CodedEnum
{
    BYTE(1, 1),
    ASCII(2, 1),
    SHORT(3, 2),
    LONG(4, 4),
    RATIONAL(5, 8),
    SBYTE(6, 1),
    UNDEFINED(7, 1),
    SSHORT(8, 2),
    SLONG(9, 4),
    SRATIONAL(10, 8),
    FLOAT(11, 4),
    DOUBLE(12, 8),
    IFD(13, 4),
    LONG8(16, 8),
    SLONG8(17, 8),
    IFD8(18, 8);

    private int code;
    private int bytesPerElement;
    private static final Map<Integer, IFDType> lookup;

    public static IFDType get(int code) {
        IFDType toReturn = lookup.get(code);
        if (toReturn == null) {
            throw new EnumException("Unable to find IFDType with code: " + code);
        }
        return toReturn;
    }

    private IFDType(int code, int bytesPerElement) {
        this.code = code;
        this.bytesPerElement = bytesPerElement;
    }

    public int getCode() {
        return this.code;
    }

    public int getBytesPerElement() {
        return this.bytesPerElement;
    }

    public static IFDType getType(Object value, boolean bigTiff) throws FormatException {
        if (value instanceof Short || value instanceof short[]) {
            return BYTE;
        }
        if (value instanceof String) {
            return ASCII;
        }
        if (value instanceof Integer || value instanceof int[]) {
            return SHORT;
        }
        if (value instanceof Long || value instanceof long[]) {
            return bigTiff ? LONG8 : LONG;
        }
        if (value instanceof TiffRational || value instanceof TiffRational[]) {
            return RATIONAL;
        }
        if (value instanceof Float || value instanceof float[]) {
            return FLOAT;
        }
        if (value instanceof Double || value instanceof double[]) {
            return DOUBLE;
        }
        if (value instanceof Boolean) {
            return UNDEFINED;
        }
        throw new FormatException("Unknown IFD value type (" + value.getClass().getName() + "): " + value);
    }

    static {
        lookup = new HashMap<Integer, IFDType>();
        for (IFDType v : EnumSet.allOf(IFDType.class)) {
            lookup.put(v.getCode(), v);
        }
    }
}

