/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.util.ResourceBundleUtil;

public class ConnectorHandle
extends AbstractHandle {
    private static final int ANCHOR_WIDTH = 6;
    private ConnectionFigure createdConnection;
    private ConnectionFigure prototype;
    private Connector connector;
    private Figure connectableFigure;
    private Connector connectableConnector;
    protected Collection<Connector> connectors = Collections.emptyList();

    public ConnectorHandle(Connector connector, ConnectionFigure prototype) {
        super(connector.getOwner());
        this.connector = connector;
        this.prototype = prototype;
    }

    public Point2D.Double getLocationOnDrawing() {
        return this.connector.getAnchor();
    }

    public Point getLocation() {
        return this.view.drawingToView(this.connector.getAnchor());
    }

    public void draw(Graphics2D g) {
        Graphics2D gg = (Graphics2D)g.create();
        gg.transform(this.view.getDrawingToViewTransform());
        for (Connector c : this.connectors) {
            c.draw(gg);
        }
        if (this.createdConnection == null) {
            this.drawCircle(g, Color.blue, Color.black);
        } else {
            this.drawCircle(g, Color.GREEN, Color.BLACK);
            Point p = this.view.drawingToView(this.createdConnection.getEndPoint());
            g.setColor(Color.GREEN);
            g.fillOval(p.x - 3, p.y - 3, 6, 6);
            g.setColor(Color.BLACK);
            g.drawOval(p.x - 3, p.y - 3, 6, 6);
        }
    }

    public void trackStart(Point anchor, int modifiersEx) {
        this.setConnection(this.createConnection());
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        Point2D.Double p = this.getLocationOnDrawing();
        this.getConnection().setStartPoint(p);
        this.getConnection().setEndPoint(p);
        this.view.getDrawing().add(this.getConnection());
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        Point2D.Double p = this.view.viewToDrawing(lead);
        Rectangle r = new Rectangle(this.view.drawingToView(this.getConnection().getEndPoint()));
        r.grow(6, 6);
        this.fireAreaInvalidated(r);
        Figure figure = this.findConnectableFigure(p, this.view.getDrawing());
        if (figure != this.connectableFigure) {
            this.connectableFigure = figure;
            this.repaintConnectors();
        }
        this.connectableConnector = this.findConnectableConnector(figure, p);
        if (this.connectableConnector != null) {
            p = this.connectableConnector.getAnchor();
        }
        this.getConnection().willChange();
        this.getConnection().setEndPoint(p);
        this.getConnection().changed();
        r = new Rectangle(this.view.drawingToView(p));
        r.grow(6, 6);
        this.fireAreaInvalidated(r);
    }

    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        Point2D.Double p = this.view.viewToDrawing(lead);
        this.view.getConstrainer().constrainPoint(p);
        Figure f = this.findConnectableFigure(p, this.view.getDrawing());
        this.connectableConnector = this.findConnectableConnector(f, p);
        if (this.connectableConnector != null) {
            final Drawing drawing = this.view.getDrawing();
            final ConnectionFigure createdConnection = this.getConnection();
            this.getConnection().setStartConnector(this.connector);
            this.getConnection().setEndConnector(this.connectableConnector);
            this.getConnection().updateConnection();
            this.view.clearSelection();
            this.view.addToSelection(createdConnection);
            this.view.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

                public String getPresentationName() {
                    ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
                    return labels.getString("createConnectionFigure");
                }

                public void undo() throws CannotUndoException {
                    super.undo();
                    drawing.remove(createdConnection);
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    drawing.add(createdConnection);
                    ConnectorHandle.this.view.clearSelection();
                    ConnectorHandle.this.view.addToSelection(createdConnection);
                }
            });
        } else {
            this.view.getDrawing().remove(this.getConnection());
        }
        this.connectableConnector = null;
        this.connectors = Collections.emptyList();
        this.setConnection(null);
        this.setTargetFigure(null);
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.prototype.clone();
    }

    protected void setConnection(ConnectionFigure newConnection) {
        this.createdConnection = newConnection;
    }

    protected ConnectionFigure getConnection() {
        return this.createdConnection;
    }

    protected Figure getTargetFigure() {
        return this.connectableFigure;
    }

    protected void setTargetFigure(Figure newTargetFigure) {
        this.connectableFigure = newTargetFigure;
    }

    private Figure findConnectableFigure(Point2D.Double p, Drawing drawing) {
        for (Figure figure : drawing.getFiguresFrontToBack()) {
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.contains(p)) continue;
            return figure;
        }
        return null;
    }

    protected Connector findConnectableConnector(Figure connectableFigure, Point2D.Double p) {
        Connector target;
        Connector connector = target = connectableFigure == null ? null : connectableFigure.findConnector(p, this.getConnection());
        if (connectableFigure != null && connectableFigure.canConnect() && !connectableFigure.includes(this.getOwner()) && this.getConnection().canConnect(this.connector, target)) {
            return target;
        }
        return null;
    }

    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        r.grow(this.getHandlesize() / 2, this.getHandlesize() / 2);
        return r;
    }

    public boolean isCombinableWith(Handle handle) {
        return false;
    }

    public void repaintConnectors() {
        Rectangle2D.Double invalidArea = null;
        for (Connector c : this.connectors) {
            if (invalidArea == null) {
                invalidArea = c.getDrawingArea();
                continue;
            }
            invalidArea.add(c.getDrawingArea());
        }
        this.connectors = this.connectableFigure == null ? new LinkedList<Connector>() : this.connectableFigure.getConnectors(this.prototype);
        for (Connector c : this.connectors) {
            if (invalidArea == null) {
                invalidArea = c.getDrawingArea();
                continue;
            }
            invalidArea.add(c.getDrawingArea());
        }
        if (invalidArea != null) {
            this.view.getComponent().repaint(this.view.drawingToView(invalidArea));
        }
    }
}

