/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.gui;

import bitronix.tm.gui.Console;
import bitronix.tm.gui.TransactionTableModel;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.utils.Decoder;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.TableModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawTransactionTableModel
extends TransactionTableModel {
    private List<TransactionLogRecord> displayedRows;
    private static final Logger log = LoggerFactory.getLogger(RawTransactionTableModel.class);
    public static final int GTRID_COL = 7;

    public RawTransactionTableModel(File filename) {
        try {
            this.readFullTransactionLog(filename);
        }
        catch (Exception ex) {
            log.error("corrupted log file", (Throwable)ex);
        }
        this.displayedRows = new ArrayList<TransactionLogRecord>(this.tLogs);
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public int getRowCount() {
        return this.displayedRows.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TransactionLogRecord tlog = this.displayedRows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return Decoder.decodeStatus(tlog.getStatus());
            }
            case 1: {
                return "" + tlog.getRecordLength();
            }
            case 2: {
                return "" + tlog.getHeaderLength();
            }
            case 3: {
                return Console.dateFormatter.format(new Date(tlog.getTime()));
            }
            case 4: {
                return "" + tlog.getSequenceNumber();
            }
            case 5: {
                return "" + tlog.getCrc32();
            }
            case 6: {
                return "" + tlog.getUniqueNames().size();
            }
            case 7: {
                return tlog.getGtrid().toString();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Record Status";
            }
            case 1: {
                return "Record length";
            }
            case 2: {
                return "Header length";
            }
            case 3: {
                return "Record time";
            }
            case 4: {
                return "Record sequence number";
            }
            case 5: {
                return "CRC";
            }
            case 6: {
                return "Resources";
            }
            case 7: {
                return "GTRID";
            }
        }
        return null;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public boolean acceptLog(TransactionLogRecord tlog) {
        return true;
    }

    @Override
    public TransactionLogRecord getRow(int row) {
        return this.displayedRows.get(row);
    }

    public void filterByGtrid(String gtrid) {
        if (gtrid == null) {
            this.displayedRows = new ArrayList<TransactionLogRecord>(this.tLogs);
        } else {
            ArrayList<TransactionLogRecord> newDis = new ArrayList<TransactionLogRecord>();
            for (int i = 0; i < this.displayedRows.size(); ++i) {
                TransactionLogRecord transactionLogRecord = this.displayedRows.get(i);
                if (!transactionLogRecord.getGtrid().toString().equals(gtrid)) continue;
                newDis.add(transactionLogRecord);
            }
            this.displayedRows = newDis;
        }
    }
}

