/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGLength;

public abstract class AbstractSVGLength
implements SVGLength {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    protected short unitType;
    protected float value;
    protected short direction;
    protected UnitProcessor.Context context = new DefaultContext();
    protected static final String[] UNITS = new String[]{"", "", "%", "em", "ex", "px", "cm", "mm", "in", "pt", "pc"};

    protected abstract SVGOMElement getAssociatedElement();

    public AbstractSVGLength(short s) {
        this.direction = s;
        this.value = 0.0f;
        this.unitType = 1;
    }

    public short getUnitType() {
        this.revalidate();
        return this.unitType;
    }

    public float getValue() {
        this.revalidate();
        try {
            return UnitProcessor.svgToUserSpace(this.value, this.unitType, this.direction, this.context);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0.0f;
        }
    }

    public void setValue(float f) throws DOMException {
        this.value = UnitProcessor.userSpaceToSVG(f, this.unitType, this.direction, this.context);
        this.reset();
    }

    public float getValueInSpecifiedUnits() {
        this.revalidate();
        return this.value;
    }

    public void setValueInSpecifiedUnits(float f) throws DOMException {
        this.revalidate();
        this.value = f;
        this.reset();
    }

    public String getValueAsString() {
        this.revalidate();
        if (this.unitType == 0) {
            return "";
        }
        return Float.toString(this.value) + UNITS[this.unitType];
    }

    public void setValueAsString(String string) throws DOMException {
        this.parse(string);
        this.reset();
    }

    public void newValueSpecifiedUnits(short s, float f) {
        this.unitType = s;
        this.value = f;
        this.reset();
    }

    public void convertToSpecifiedUnits(short s) {
        float f = this.getValue();
        this.unitType = s;
        this.setValue(f);
    }

    protected void reset() {
    }

    protected void revalidate() {
    }

    protected void parse(String string) {
        try {
            LengthParser lengthParser = new LengthParser();
            UnitProcessor.UnitResolver unitResolver = new UnitProcessor.UnitResolver();
            lengthParser.setLengthHandler(unitResolver);
            lengthParser.parse(string);
            this.unitType = unitResolver.unit;
            this.value = unitResolver.value;
        }
        catch (ParseException parseException) {
            this.unitType = 0;
            this.value = 0.0f;
        }
    }

    protected class DefaultContext
    implements UnitProcessor.Context {
        protected DefaultContext() {
        }

        @Override
        public Element getElement() {
            return AbstractSVGLength.this.getAssociatedElement();
        }

        @Override
        public float getPixelUnitToMillimeter() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getPixelUnitToMillimeter();
        }

        @Override
        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        @Override
        public float getFontSize() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getFontSize();
        }

        @Override
        public float getXHeight() {
            return 0.5f;
        }

        @Override
        public float getViewportWidth() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getViewportWidth();
        }

        @Override
        public float getViewportHeight() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getViewportHeight();
        }
    }
}

