/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcClassHelper {
    private static final Logger log = LoggerFactory.getLogger(JdbcClassHelper.class);
    private static final int DETECTION_TIMEOUT = 5;
    private static final Map<Class<Connection>, Integer> connectionClassVersions = new ConcurrentHashMap<Class<Connection>, Integer>();
    private static final Map<Class<? extends Connection>, Method> isValidMethods = new ConcurrentHashMap<Class<? extends Connection>, Method>();

    public static int detectJdbcVersion(Connection connection) {
        Class<?> connectionClass = connection.getClass();
        Integer jdbcVersionDetected = connectionClassVersions.get(connectionClass);
        if (jdbcVersionDetected != null) {
            return jdbcVersionDetected;
        }
        try {
            Method isValidMethod = connectionClass.getMethod("isValid", Integer.TYPE);
            isValidMethod.invoke((Object)connection, new Integer(5));
            jdbcVersionDetected = 4;
            isValidMethods.put(connectionClass, isValidMethod);
        }
        catch (Exception ex) {
            jdbcVersionDetected = 3;
        }
        catch (AbstractMethodError er) {
            jdbcVersionDetected = 3;
        }
        connectionClassVersions.put(connectionClass, jdbcVersionDetected);
        if (log.isDebugEnabled()) {
            log.debug("detected JDBC connection class '" + connectionClass + "' is version " + jdbcVersionDetected + " type");
        }
        return jdbcVersionDetected;
    }

    public static Method getIsValidMethod(Connection connection) {
        JdbcClassHelper.detectJdbcVersion(connection);
        return isValidMethods.get(connection.getClass());
    }
}

