/*
 * Decompiled with CFR 0.152.
 */
package loci.common.image;

import loci.common.image.IImageScaler;

public class SimpleImageScaler
implements IImageScaler {
    @Override
    public byte[] downsample(byte[] srcImage, int width, int height, double scaleFactor, int bytesPerPixel, boolean littleEndian, boolean floatingPoint, int channels, boolean interleaved) {
        if (scaleFactor < 1.0) {
            throw new IllegalArgumentException("Scale factor cannot be less than 1");
        }
        int newW = (int)((double)width / scaleFactor);
        int newH = (int)((double)height / scaleFactor);
        if (newW == 0 || newH == 0) {
            throw new IllegalArgumentException("Scale factor too large; new width = " + newW + ", new height = " + newH);
        }
        if (newW == width && newH == height) {
            return srcImage;
        }
        int yd = height / newH * width - width;
        int yr = height % newH;
        int xd = width / newW;
        int xr = width % newW;
        byte[] outBuf = new byte[newW * newH * bytesPerPixel * channels];
        int count = interleaved ? 1 : channels;
        int pixelChannels = interleaved ? channels : 1;
        for (int c = 0; c < count; ++c) {
            int srcOffset = c * width * height;
            int destOffset = c * newW * newH;
            int ye = 0;
            for (int yyy = newH; yyy > 0; --yyy) {
                int xe = 0;
                for (int xxx = newW; xxx > 0; --xxx) {
                    for (int rgb = 0; rgb < pixelChannels; ++rgb) {
                        for (int b = 0; b < bytesPerPixel; ++b) {
                            outBuf[bytesPerPixel * (destOffset * pixelChannels + rgb) + b] = srcImage[bytesPerPixel * (srcOffset * pixelChannels + rgb) + b];
                        }
                    }
                    ++destOffset;
                    srcOffset += xd;
                    if ((xe += xr) < newW) continue;
                    xe -= newW;
                    ++srcOffset;
                }
                srcOffset += yd;
                if ((ye += yr) < newH) continue;
                ye -= newH;
                srcOffset += width;
            }
        }
        return outBuf;
    }
}

