/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.teddyapplication;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.samples.teddyapplication.TeddyView;

public class CharacterSetAccessory
extends JPanel {
    private static final Preferences prefs = Preferences.userNodeForPackage(TeddyView.class);
    private static Object[] availableCharSets;
    public JComboBox charSetCombo;
    public JLabel charSetLabel;
    public JComboBox lineSepCombo;
    public JLabel lineSepLabel;

    public CharacterSetAccessory() {
        if (UIManager.getLookAndFeel().getID().toLowerCase().equals("aqua")) {
            this.initComponents();
        } else {
            this.initComponentsWin();
        }
        String selectedItem = prefs.get("characterSet", "UTF-8");
        this.charSetCombo.setModel(new DefaultComboBoxModel<String>(new String[]{selectedItem}));
        this.charSetCombo.setSelectedItem(selectedItem);
        this.charSetCombo.setEnabled(false);
        this.fetchAvailableCharSets();
        String lineSeparator = prefs.get("lineSeparator", "\n");
        if (lineSeparator.equals("\r")) {
            this.lineSepCombo.setSelectedIndex(0);
        } else if (lineSeparator.equals("\n")) {
            this.lineSepCombo.setSelectedIndex(1);
        } else if (lineSeparator.equals("\r\n")) {
            this.lineSepCombo.setSelectedIndex(2);
        }
    }

    public void fetchAvailableCharSets() {
        if (availableCharSets == null) {
            new Worker(){

                public Object construct() {
                    SortedMap<String, Charset> sm = Charset.availableCharsets();
                    LinkedList<String> list = new LinkedList<String>();
                    for (String key : sm.keySet()) {
                        if (key.startsWith("x-")) continue;
                        list.add(key);
                    }
                    CharacterSetAccessory.access$002(list.toArray());
                    Arrays.sort(availableCharSets);
                    return null;
                }

                public void finished(Object value) {
                    Object selectedItem = CharacterSetAccessory.this.charSetCombo.getSelectedItem();
                    CharacterSetAccessory.this.charSetCombo.setModel(new DefaultComboBoxModel<Object>(availableCharSets));
                    CharacterSetAccessory.this.charSetCombo.setSelectedItem(selectedItem);
                    CharacterSetAccessory.this.charSetCombo.setEnabled(true);
                }
            }.start();
        } else {
            Object selectedItem = this.charSetCombo.getSelectedItem();
            this.charSetCombo.setModel(new DefaultComboBoxModel<Object>(availableCharSets));
            this.charSetCombo.setSelectedItem(selectedItem);
            this.charSetCombo.setEnabled(true);
        }
    }

    public String getCharacterSet() {
        prefs.put("characterSet", (String)this.charSetCombo.getSelectedItem());
        return (String)this.charSetCombo.getSelectedItem();
    }

    public String getLineSeparator() {
        String lineSeparator;
        switch (this.charSetCombo.getSelectedIndex()) {
            default: {
                lineSeparator = "\n";
                break;
            }
            case 1: {
                lineSeparator = "\r";
                break;
            }
            case 2: {
                lineSeparator = "\r\n";
            }
        }
        prefs.put("lineSeparator", lineSeparator);
        return lineSeparator;
    }

    private void initComponents() {
        this.charSetLabel = new JLabel();
        this.charSetCombo = new JComboBox();
        this.lineSepLabel = new JLabel();
        this.lineSepCombo = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.charSetLabel.setText("Character Set:");
        this.charSetCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lineSepLabel.setText("Line Separator:");
        this.lineSepCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"CR", "LF", "CR LF"}));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.charSetLabel).addPreferredGap(0).add((Component)this.charSetCombo, -2, -1, -2).add(15, 15, 15).add((Component)this.lineSepLabel).addPreferredGap(0).add((Component)this.lineSepCombo, -2, -1, -2).addContainerGap(44, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.charSetCombo, -2, -1, -2).add((Component)this.charSetLabel).add((Component)this.lineSepLabel).add((Component)this.lineSepCombo, -2, -1, -2));
    }

    private void initComponentsWin() {
        this.charSetLabel = new JLabel();
        this.charSetCombo = new JComboBox();
        this.lineSepLabel = new JLabel();
        this.lineSepCombo = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.charSetLabel.setText("Character Set:");
        this.charSetCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lineSepLabel.setText("Line Separator:");
        this.lineSepCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"CR", "LF", "CR LF"}));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.charSetLabel).add((Component)this.charSetCombo, -2, -1, -2).add((Component)this.lineSepLabel).add((Component)this.lineSepCombo, -2, -1, -2));
        layout.setVerticalGroup((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.charSetLabel).add((Component)this.charSetCombo, -2, -1, -2).addPreferredGap(1).add((Component)this.lineSepLabel).add((Component)this.lineSepCombo, -2, -1, -2));
    }

    static /* synthetic */ Object[] access$002(Object[] x0) {
        availableCharSets = x0;
        return x0;
    }
}

