/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.filter.NameMatch;
import edu.umd.cs.findbugs.util.Util;

public class MemberMatcher {
    protected final NameMatch name;
    @CheckForNull
    protected final String signature;

    public MemberMatcher(String name) {
        this.name = new NameMatch(name);
        this.signature = null;
    }

    public MemberMatcher(String name, String signature) {
        if (name == null) {
            if (signature == null) {
                throw new FilterException(this.getClass().getName() + " must have eiter name or signature attributes");
            }
            name = "~.*";
        }
        this.name = new NameMatch(name);
        this.signature = signature;
    }

    public int hashCode() {
        return this.name.hashCode() + Util.nullSafeHashcode(this.signature);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberMatcher other = (MemberMatcher)o;
        return this.name.equals(other.name) && Util.nullSafeEquals(this.signature, other.signature);
    }
}

