/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwoPhaseLoad {
    private static final Logger log = LoggerFactory.getLogger(TwoPhaseLoad.class);

    private TwoPhaseLoad() {
    }

    public static void postHydrate(EntityPersister persister, Serializable id, Object[] values, Object rowId, Object object, LockMode lockMode, boolean lazyPropertiesAreUnfetched, SessionImplementor session) throws HibernateException {
        Object version = Versioning.getVersion(values, persister);
        session.getPersistenceContext().addEntry(object, Status.LOADING, values, rowId, id, version, lockMode, true, persister, false, lazyPropertiesAreUnfetched);
        if (log.isTraceEnabled() && version != null) {
            String versionStr = persister.isVersioned() ? persister.getVersionType().toLoggableString(version, session.getFactory()) : "null";
            log.trace("Version: " + versionStr);
        }
    }

    public static void initializeEntity(Object entity, boolean readOnly, SessionImplementor session, PreLoadEvent preLoadEvent, PostLoadEvent postLoadEvent) throws HibernateException {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(entity);
        if (entityEntry == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        EntityPersister persister = entityEntry.getPersister();
        Serializable id = entityEntry.getId();
        Object[] hydratedState = entityEntry.getLoadedState();
        if (log.isDebugEnabled()) {
            log.debug("resolving associations for " + MessageHelper.infoString(persister, id, session.getFactory()));
        }
        Type[] types = persister.getPropertyTypes();
        for (int i = 0; i < hydratedState.length; ++i) {
            Object value = hydratedState[i];
            if (value == LazyPropertyInitializer.UNFETCHED_PROPERTY || value == BackrefPropertyAccessor.UNKNOWN) continue;
            hydratedState[i] = types[i].resolve(value, session, entity);
        }
        if (session.isEventSource()) {
            preLoadEvent.setEntity(entity).setState(hydratedState).setId(id).setPersister(persister);
            PreLoadEventListener[] listeners = session.getListeners().getPreLoadEventListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].onPreLoad(preLoadEvent);
            }
        }
        persister.setPropertyValues(entity, hydratedState, session.getEntityMode());
        SessionFactoryImplementor factory = session.getFactory();
        if (persister.hasCache() && session.getCacheMode().isPutEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("adding entity to second-level cache: " + MessageHelper.infoString(persister, id, session.getFactory()));
            }
            Object version = Versioning.getVersion(hydratedState, persister);
            CacheEntry entry = new CacheEntry(hydratedState, persister, entityEntry.isLoadedWithLazyPropertiesUnfetched(), version, session, entity);
            CacheKey cacheKey = new CacheKey(id, persister.getIdentifierType(), persister.getRootEntityName(), session.getEntityMode(), session.getFactory());
            if (session.wasInsertedDuringTransaction(persister, id)) {
                persister.getCacheAccessStrategy().update(cacheKey, persister.getCacheEntryStructure().structure(entry), version, version);
            } else {
                boolean put = persister.getCacheAccessStrategy().putFromLoad(cacheKey, persister.getCacheEntryStructure().structure(entry), session.getTimestamp(), version, TwoPhaseLoad.useMinimalPuts(session, entityEntry));
                if (put && factory.getStatistics().isStatisticsEnabled()) {
                    factory.getStatisticsImplementor().secondLevelCachePut(persister.getCacheAccessStrategy().getRegion().getName());
                }
            }
        }
        boolean isReallyReadOnly = readOnly;
        if (!persister.isMutable()) {
            isReallyReadOnly = true;
        } else {
            Object proxy = persistenceContext.getProxy(entityEntry.getEntityKey());
            if (proxy != null) {
                isReallyReadOnly = ((HibernateProxy)proxy).getHibernateLazyInitializer().isReadOnly();
            }
        }
        if (isReallyReadOnly) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            TypeFactory.deepCopy(hydratedState, persister.getPropertyTypes(), persister.getPropertyUpdateability(), hydratedState, session);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        persister.afterInitialize(entity, entityEntry.isLoadedWithLazyPropertiesUnfetched(), session);
        if (session.isEventSource()) {
            postLoadEvent.setEntity(entity).setId(id).setPersister(persister);
            PostLoadEventListener[] listeners = session.getListeners().getPostLoadEventListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].onPostLoad(postLoadEvent);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("done materializing entity " + MessageHelper.infoString(persister, id, session.getFactory()));
        }
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().loadEntity(persister.getEntityName());
        }
    }

    private static boolean useMinimalPuts(SessionImplementor session, EntityEntry entityEntry) {
        return session.getFactory().getSettings().isMinimalPutsEnabled() && session.getCacheMode() != CacheMode.REFRESH || entityEntry.getPersister().hasLazyProperties() && entityEntry.isLoadedWithLazyPropertiesUnfetched() && entityEntry.getPersister().isLazyPropertiesCacheable();
    }

    public static void addUninitializedEntity(EntityKey key, Object object, EntityPersister persister, LockMode lockMode, boolean lazyPropertiesAreUnfetched, SessionImplementor session) {
        session.getPersistenceContext().addEntity(object, Status.LOADING, null, key, null, lockMode, true, persister, false, lazyPropertiesAreUnfetched);
    }

    public static void addUninitializedCachedEntity(EntityKey key, Object object, EntityPersister persister, LockMode lockMode, boolean lazyPropertiesAreUnfetched, Object version, SessionImplementor session) {
        session.getPersistenceContext().addEntity(object, Status.LOADING, null, key, version, lockMode, true, persister, false, lazyPropertiesAreUnfetched);
    }
}

