/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.gui;

import bitronix.tm.gui.TransactionTableModel;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.Uid;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TableModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingTransactionTableModel
extends TransactionTableModel {
    private static final Logger log = LoggerFactory.getLogger(PendingTransactionTableModel.class);
    private Map<Uid, TransactionLogRecord> pendingTLogs = new HashMap<Uid, TransactionLogRecord>();

    public PendingTransactionTableModel(File filename) {
        try {
            this.readFullTransactionLog(filename);
        }
        catch (Exception ex) {
            log.error("corrupted log file", (Throwable)ex);
        }
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public int getRowCount() {
        return this.tLogs.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TransactionLogRecord tlog = (TransactionLogRecord)this.tLogs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return Decoder.decodeStatus(tlog.getStatus());
            }
            case 1: {
                return Integer.toString(tlog.getRecordLength());
            }
            case 2: {
                return Integer.toString(tlog.getHeaderLength());
            }
            case 3: {
                return Long.toString(tlog.getTime());
            }
            case 4: {
                return Integer.toString(tlog.getSequenceNumber());
            }
            case 5: {
                return Integer.toString(tlog.getCrc32());
            }
            case 6: {
                return Integer.toString(tlog.getUniqueNames().size());
            }
            case 7: {
                return tlog.getGtrid().toString();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Record Status";
            }
            case 1: {
                return "Record length";
            }
            case 2: {
                return "Header length";
            }
            case 3: {
                return "Record time";
            }
            case 4: {
                return "Record sequence number";
            }
            case 5: {
                return "CRC";
            }
            case 6: {
                return "Resources";
            }
            case 7: {
                return "GTRID";
            }
        }
        return null;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    protected void readFullTransactionLog(File filename) throws IOException {
        super.readFullTransactionLog(filename);
        this.pendingTLogs.clear();
    }

    @Override
    public boolean acceptLog(TransactionLogRecord tlog) {
        if (tlog.getStatus() == 8) {
            this.pendingTLogs.put(tlog.getGtrid(), tlog);
            return true;
        }
        if (tlog.getStatus() == 3 || tlog.getStatus() == 4 && this.pendingTLogs.containsKey(tlog.getGtrid())) {
            this.tLogs.remove(this.pendingTLogs.get(tlog.getGtrid()));
        }
        return false;
    }

    @Override
    public TransactionLogRecord getRow(int row) {
        return (TransactionLogRecord)this.tLogs.get(row);
    }
}

