/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.pert.figures;

import java.awt.Color;
import org.jhotdraw.draw.ArrowTip;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.samples.pert.figures.TaskFigure;

public class DependencyFigure
extends LineConnectionFigure {
    public DependencyFigure() {
        AttributeKeys.STROKE_COLOR.basicSet(this, new Color(153));
        AttributeKeys.STROKE_WIDTH.basicSet(this, 1.0);
        AttributeKeys.END_DECORATION.basicSet(this, new ArrowTip());
        this.setAttributeEnabled(AttributeKeys.END_DECORATION, false);
        this.setAttributeEnabled(AttributeKeys.START_DECORATION, false);
        this.setAttributeEnabled(AttributeKeys.STROKE_DASHES, false);
        this.setAttributeEnabled(AttributeKeys.FONT_ITALIC, false);
        this.setAttributeEnabled(AttributeKeys.FONT_UNDERLINE, false);
    }

    public boolean canConnect(Connector start, Connector end) {
        if (start.getOwner() instanceof TaskFigure && end.getOwner() instanceof TaskFigure) {
            TaskFigure sf = (TaskFigure)start.getOwner();
            TaskFigure ef = (TaskFigure)end.getOwner();
            if (ef.getPredecessors().contains(sf)) {
                return false;
            }
            return !sf.isDependentOf(ef);
        }
        return false;
    }

    public boolean canConnect(Connector start) {
        return start.getOwner() instanceof TaskFigure;
    }

    protected void handleDisconnect(Connector start, Connector end) {
        TaskFigure sf = (TaskFigure)start.getOwner();
        TaskFigure ef = (TaskFigure)end.getOwner();
        sf.removeDependency(this);
        ef.removeDependency(this);
    }

    protected void handleConnect(Connector start, Connector end) {
        TaskFigure sf = (TaskFigure)start.getOwner();
        TaskFigure ef = (TaskFigure)end.getOwner();
        sf.addDependency(this);
        ef.addDependency(this);
    }

    public DependencyFigure clone() {
        DependencyFigure that = (DependencyFigure)super.clone();
        return that;
    }

    public int getLayer() {
        return 1;
    }

    public void removeNotify(Drawing d) {
        if (this.getStartFigure() != null) {
            ((TaskFigure)this.getStartFigure()).removeDependency(this);
        }
        if (this.getEndFigure() != null) {
            ((TaskFigure)this.getEndFigure()).removeDependency(this);
        }
        super.removeNotify(d);
    }
}

