/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractProjectAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class RedoAction
extends AbstractProjectAction {
    public static final String ID = "redo";
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
    private PropertyChangeListener redoActionPropertyListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "Name") {
                RedoAction.this.putValue("Name", evt.getNewValue());
            } else if (name == "enabled") {
                RedoAction.this.updateEnabledState();
            }
        }
    };

    public RedoAction(Application app) {
        super(app);
        this.labels.configureAction(this, ID);
    }

    protected void updateEnabledState() {
        boolean isEnabled = false;
        Action realRedoAction = this.getRealRedoAction();
        if (realRedoAction != null) {
            isEnabled = realRedoAction.isEnabled();
        }
        this.setEnabled(isEnabled);
    }

    protected void updateProject(Project oldValue, Project newValue) {
        super.updateProject(oldValue, newValue);
        if (newValue != null && newValue.getAction(ID) != null) {
            this.putValue("Name", newValue.getAction(ID).getValue("Name"));
            this.updateEnabledState();
        }
    }

    protected void installProjectListeners(Project p) {
        super.installProjectListeners(p);
        if (p.getAction(ID) != null) {
            p.getAction(ID).addPropertyChangeListener(this.redoActionPropertyListener);
        }
    }

    protected void uninstallProjectListeners(Project p) {
        super.uninstallProjectListeners(p);
        if (p.getAction(ID) != null) {
            p.getAction(ID).removePropertyChangeListener(this.redoActionPropertyListener);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Action realRedoAction = this.getRealRedoAction();
        if (realRedoAction != null) {
            realRedoAction.actionPerformed(e);
        }
    }

    private Action getRealRedoAction() {
        return this.getCurrentProject() == null ? null : this.getCurrentProject().getAction(ID);
    }
}

