/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.application.DocumentOrientedApplication;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AbstractApplicationAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;

public class ExitAction
extends AbstractApplicationAction {
    public static final String ID = "Application.exit";
    private Component oldFocusOwner;
    private DocumentView unsavedProject;

    public ExitAction() {
        this.initActionProperties(ID);
    }

    public void actionPerformed(ActionEvent evt) {
        final DocumentOrientedApplication application = this.getApplication();
        if (application.isEnabled()) {
            application.setEnabled(false);
            int unsavedProjectsCount = 0;
            DocumentView documentToBeReviewed = null;
            for (DocumentView p : application.getViews()) {
                if (!p.isModified()) continue;
                if (p.isEnabled()) {
                    documentToBeReviewed = p;
                }
                ++unsavedProjectsCount;
            }
            if (unsavedProjectsCount > 0 && documentToBeReviewed == null) {
                application.setEnabled(true);
                return;
            }
            switch (unsavedProjectsCount) {
                case 0: {
                    this.doExit();
                    break;
                }
                case 1: {
                    this.unsavedProject = documentToBeReviewed;
                    this.oldFocusOwner = SwingUtilities.getWindowAncestor(this.unsavedProject.getComponent()).getFocusOwner();
                    this.unsavedProject.setEnabled(false);
                    JOptionPane pane = new JOptionPane("<html>" + UIManager.getString("OptionPane.css") + "<b>Do you want to save changes to this document " + "before exiting?</b><p>" + "If you don't save, your changes will be lost.", 2);
                    Object[] options = new Object[]{"Save", "Cancel", "Don't Save"};
                    pane.setOptions(options);
                    pane.setInitialValue(options[0]);
                    pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
                    JSheet.showSheet(pane, this.unsavedProject.getComponent(), new SheetListener(){

                        public void optionSelected(SheetEvent evt) {
                            Object value = evt.getValue();
                            if (value == null || value.equals("Cancel")) {
                                ExitAction.this.unsavedProject.setEnabled(true);
                                application.setEnabled(true);
                            } else if (value.equals("Don't Save")) {
                                ExitAction.this.doExit();
                                ExitAction.this.unsavedProject.setEnabled(true);
                            } else if (value.equals("Save")) {
                                ExitAction.this.saveChanges();
                            }
                        }
                    });
                    break;
                }
                default: {
                    JOptionPane pane = new JOptionPane("<html>" + UIManager.get("OptionPane.css") + "<b>You have " + unsavedProjectsCount + " documents with unsaved changes. " + "Do you want to " + "review these changes before quitting?</b><p>" + "If you don't review your documents, " + "all your changes will be lost.", 3);
                    Object[] options = new Object[]{"Review Changes", "Cancel", "Discard Changes"};
                    pane.setOptions(options);
                    pane.setInitialValue(options[0]);
                    pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
                    JDialog dialog = pane.createDialog(application.getComponent(), null);
                    dialog.setVisible(true);
                    Object value = pane.getValue();
                    if (value == null || value.equals("Cancel")) {
                        application.setEnabled(true);
                        break;
                    }
                    if (value.equals("Discard Changes")) {
                        this.doExit();
                        application.setEnabled(true);
                        break;
                    }
                    if (!value.equals("Review Changes")) break;
                    this.unsavedProject = documentToBeReviewed;
                    this.reviewChanges();
                }
            }
        }
    }

    protected void saveChanges() {
        if (this.unsavedProject.getFile() == null) {
            JFileChooser fileChooser = this.unsavedProject.getSaveChooser();
            JSheet.showSaveSheet(fileChooser, this.unsavedProject.getComponent(), new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getSelectedFile();
                        ExitAction.this.saveToFile(file);
                    } else {
                        ExitAction.this.unsavedProject.setEnabled(true);
                        if (ExitAction.this.oldFocusOwner != null) {
                            ExitAction.this.oldFocusOwner.requestFocus();
                        }
                        ExitAction.this.getApplication().setEnabled(true);
                    }
                }
            });
        } else {
            this.saveToFile(this.unsavedProject.getFile());
        }
    }

    protected void reviewChanges() {
        if (this.unsavedProject.isEnabled()) {
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(this.unsavedProject.getComponent()).getFocusOwner();
            this.unsavedProject.setEnabled(false);
            JOptionPane pane = new JOptionPane("<html>" + UIManager.getString("OptionPane.css") + "<b>Do you want to save changes to this document " + "before exiting?</b><p>" + "If you don't save, your changes will be lost.", 2);
            Object[] options = new Object[]{"Save", "Cancel", "Don't Save"};
            pane.setOptions(options);
            pane.setInitialValue(options[0]);
            pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
            JSheet.showSheet(pane, this.unsavedProject.getComponent(), new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                    Object value = evt.getValue();
                    if (value == null || value.equals("Cancel")) {
                        ExitAction.this.unsavedProject.setEnabled(true);
                        ExitAction.this.getApplication().setEnabled(true);
                    } else if (value.equals("Don't Save")) {
                        ExitAction.this.getApplication().remove(ExitAction.this.unsavedProject);
                        ExitAction.this.reviewNext();
                    } else if (value.equals("Save")) {
                        ExitAction.this.saveChangesAndReviewNext();
                    }
                }
            });
        } else {
            this.getApplication().setEnabled(true);
            System.out.println("review silently aborted");
        }
    }

    protected void saveChangesAndReviewNext() {
        if (this.unsavedProject.getFile() == null) {
            JFileChooser fileChooser = this.unsavedProject.getSaveChooser();
            JSheet.showSaveSheet(fileChooser, this.unsavedProject.getComponent(), new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getSelectedFile();
                        ExitAction.this.saveToFileAndReviewNext(file);
                    } else {
                        ExitAction.this.unsavedProject.setEnabled(true);
                        if (ExitAction.this.oldFocusOwner != null) {
                            ExitAction.this.oldFocusOwner.requestFocus();
                        }
                        ExitAction.this.getApplication().setEnabled(true);
                    }
                }
            });
        } else {
            this.saveToFileAndReviewNext(this.unsavedProject.getFile());
        }
    }

    protected void reviewNext() {
        int unsavedProjectsCount = 0;
        DocumentView documentToBeReviewed = null;
        for (DocumentView p : this.getApplication().getViews()) {
            if (!p.isModified()) continue;
            if (p.isEnabled()) {
                documentToBeReviewed = p;
            }
            ++unsavedProjectsCount;
        }
        if (unsavedProjectsCount == 0) {
            this.doExit();
        } else if (documentToBeReviewed != null) {
            this.unsavedProject = documentToBeReviewed;
            this.reviewChanges();
        } else {
            this.getApplication().setEnabled(true);
        }
    }

    protected void saveToFile(final File file) {
        this.unsavedProject.execute(new Worker(){

            public Object construct() {
                try {
                    ExitAction.this.unsavedProject.write(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            public void finished(Object value) {
                ExitAction.this.fileSaved(ExitAction.this.unsavedProject, file, value);
            }
        });
    }

    protected void saveToFileAndReviewNext(final File file) {
        this.unsavedProject.execute(new Worker(){

            public Object construct() {
                try {
                    ExitAction.this.unsavedProject.write(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            public void finished(Object value) {
                ExitAction.this.fileSavedAndReviewNext(ExitAction.this.unsavedProject, file, value);
            }
        });
    }

    protected void fileSaved(DocumentView unsavedProject, File file, Object value) {
        if (value == null) {
            unsavedProject.setFile(file);
            this.doExit();
        } else {
            JSheet.showMessageSheet((Component)unsavedProject.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't save to the file \"" + file + "\".<p>" + "Reason: " + value), 0);
        }
        unsavedProject.setEnabled(true);
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
        this.getApplication().setEnabled(true);
    }

    protected void fileSavedAndReviewNext(DocumentView unsavedProject, File file, Object value) {
        if (value == null) {
            unsavedProject.setFile(file);
            this.getApplication().remove(unsavedProject);
            this.reviewNext();
            return;
        }
        JSheet.showMessageSheet((Component)unsavedProject.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't save to the file \"" + file + "\".<p>" + "Reason: " + value), 0);
        unsavedProject.setEnabled(true);
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
        this.getApplication().setEnabled(true);
    }

    protected void doExit() {
        this.getApplication().shutdown();
        System.exit(0);
    }
}

