/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.gui.AttributeField;
import org.jhotdraw.gui.AttributeFieldEventHandler;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDoubleAttributeField
extends JFormattedTextField
implements AttributeField {
    private static final boolean DEBUG = false;
    private double scaleFactor = 1.0;
    private double min = Double.MIN_VALUE;
    private double max = Double.MAX_VALUE;
    private AttributeKey<Double> attributeKey;
    private boolean isMultipleValues;
    protected ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
    private int isUpdatingField = 0;
    private AttributeFieldEventHandler eventHandler = new AttributeFieldEventHandler(this);

    public JDoubleAttributeField() {
        this(null, null);
    }

    public JDoubleAttributeField(DrawingEditor editor, AttributeKey<Double> attributeKey) {
        this.initComponents();
        this.attributeKey = attributeKey;
        this.setEditor(editor);
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                JDoubleAttributeField.this.updateFigures();
            }

            public void removeUpdate(DocumentEvent e) {
                JDoubleAttributeField.this.updateFigures();
            }

            public void changedUpdate(DocumentEvent e) {
                JDoubleAttributeField.this.updateFigures();
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDoubleAttributeField.this.updateFigures();
            }
        });
    }

    public void setAttributeKey(AttributeKey<Double> newValue) {
        AttributeKey<Double> oldValue = this.attributeKey;
        this.attributeKey = newValue;
        this.updateField(this.eventHandler.getCurrentSelection());
        this.firePropertyChange("attributeKey", oldValue, newValue);
    }

    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.eventHandler.getEditor();
        this.eventHandler.setEditor(newValue);
        this.firePropertyChange("editor", oldValue, newValue);
    }

    public DrawingEditor getEditor() {
        return this.eventHandler.getEditor();
    }

    public void setView(DrawingView newValue) {
        DrawingView oldValue = this.eventHandler.getView();
        this.eventHandler.setView(newValue);
        this.firePropertyChange("view", oldValue, newValue);
    }

    public DrawingView getView() {
        return this.eventHandler.getView();
    }

    public void setScaleFactor(double newValue) {
        this.scaleFactor = newValue;
        this.updateField(this.eventHandler.getCurrentSelection());
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setMinimum(double newValue) {
        this.min = newValue;
    }

    public double getMinimum() {
        return this.min;
    }

    public void setMaximum(double newValue) {
        this.max = newValue;
    }

    public double getMaximum() {
        return this.max;
    }

    @Override
    public void updateField(Set<Figure> currentSelection) {
        if (this.isUpdatingField++ == 0) {
            if (currentSelection.isEmpty() || this.attributeKey == null) {
                this.setValue(0.0);
            } else {
                Double fieldValue = null;
                boolean isFirst = true;
                this.isMultipleValues = false;
                for (Figure f : currentSelection) {
                    if (isFirst) {
                        isFirst = false;
                        fieldValue = this.attributeKey.get(f);
                        continue;
                    }
                    Double figureValue = this.attributeKey.get(f);
                    if (figureValue == fieldValue || figureValue != null && fieldValue != null && figureValue.equals(fieldValue)) continue;
                    fieldValue = null;
                    this.isMultipleValues = true;
                }
                if (fieldValue != null) {
                    this.setValue(fieldValue * this.scaleFactor);
                }
            }
            this.repaint();
        }
        --this.isUpdatingField;
    }

    private void updateFigures() {
        if (this.isUpdatingField++ == 0) {
            Double fieldValue = Math.min(Math.max(this.min, (Double)this.getValue()), this.max) / this.scaleFactor;
            if (!this.eventHandler.getCurrentSelection().isEmpty() && this.attributeKey != null) {
                for (Figure f : this.eventHandler.getCurrentSelection()) {
                    this.attributeKey.set(f, fieldValue);
                }
            }
            this.eventHandler.getEditor().setDefaultAttribute(this.attributeKey, fieldValue);
        }
        --this.isUpdatingField;
    }

    public void dispose() {
        this.eventHandler.dispose();
    }

    private void initComponents() {
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isFocusOwner() && this.isMultipleValues) {
            Insets insets = this.getInsets();
            Insets margin = this.getMargin();
            int height = this.getHeight();
            FontMetrics fm = g.getFontMetrics(this.getFont());
            g.setFont(this.getFont().deriveFont(2));
            g.drawString(this.labels.getString("multipleValues"), insets.left + margin.left, insets.top + margin.top + fm.getAscent());
        } else {
            super.paintComponent(g);
        }
    }

    public JDoubleAttributeField clone() {
        try {
            JDoubleAttributeField that = (JDoubleAttributeField)super.clone();
            that.eventHandler = new AttributeFieldEventHandler(that);
            return that;
        }
        catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError(ex.getMessage());
            error.initCause(ex);
            throw error;
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

