/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import ome.model.internal.Permissions;
import ome.security.SecurityFilter;
import ome.system.EventContext;
import ome.system.Roles;
import org.hibernate.Filter;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.FilterDefinitionFactoryBean;

public abstract class AbstractSecurityFilter
extends FilterDefinitionFactoryBean
implements SecurityFilter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Roles roles;

    public AbstractSecurityFilter() {
        this(new Roles());
    }

    public AbstractSecurityFilter(Roles roles) {
        this.roles = roles;
        this.setFilterName(this.getName());
        this.setParameterTypes(this.getParameterTypes());
        this.setDefaultFilterCondition(this.getDefaultCondition());
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void disable(Session sess) {
        sess.disableFilter(this.getName());
        this.disableBaseFilters(sess);
    }

    public boolean isNonPrivate(EventContext c) {
        return c.getCurrentGroupPermissions().isGranted(Permissions.Role.GROUP, Permissions.Right.READ) || c.getCurrentGroupPermissions().isGranted(Permissions.Role.WORLD, Permissions.Right.READ);
    }

    public boolean isAdminOrPi(EventContext c) {
        return c.isCurrentUserAdmin() || c.getLeaderOfGroupsList().contains(c.getCurrentGroupId());
    }

    public boolean isShare(EventContext c) {
        return c.getCurrentShareId() != null;
    }

    protected void enableBaseFilters(Session sess, int admin01, Long currentUserId) {
        Filter sessionFilter = sess.enableFilter("owner_or_admin");
        sessionFilter.setParameter("is_admin", (Object)admin01);
        sessionFilter.setParameter("current_user", (Object)currentUserId);
    }

    protected void disableBaseFilters(Session sess) {
        sess.disableFilter("owner_or_admin");
    }
}

