/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.solr.client.solrj.request.JavaBinUpdateRequestCodec;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryUpdateRequestHandler
extends ContentStreamHandlerBase {
    @Override
    protected ContentStreamLoader newLoader(SolrQueryRequest req, final UpdateRequestProcessor processor) {
        return new ContentStreamLoader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream) throws Exception {
                InputStream is = null;
                try {
                    is = stream.getStream();
                    BinaryUpdateRequestHandler.this.parseAndLoadDocs(req, rsp, is, processor);
                    Object var6_5 = null;
                    if (is == null) return;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
        };
    }

    private void parseAndLoadDocs(SolrQueryRequest req, SolrQueryResponse rsp, InputStream stream, final UpdateRequestProcessor processor) throws IOException {
        UpdateRequest update = null;
        update = new JavaBinUpdateRequestCodec().unmarshal(stream, new JavaBinUpdateRequestCodec.StreamingDocumentHandler(){
            private AddUpdateCommand addCmd = null;

            public void document(SolrInputDocument document, UpdateRequest updateRequest) {
                if (this.addCmd == null) {
                    this.addCmd = BinaryUpdateRequestHandler.this.getAddCommand((SolrParams)updateRequest.getParams());
                }
                this.addCmd.solrDoc = document;
                try {
                    processor.processAdd(this.addCmd);
                    this.addCmd.clear();
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ERROR adding document " + document);
                }
            }
        });
        if (update.getDeleteById() != null) {
            this.delete(update.getDeleteById(), processor, true);
        }
        if (update.getDeleteQuery() != null) {
            this.delete(update.getDeleteQuery(), processor, false);
        }
    }

    private AddUpdateCommand getAddCommand(SolrParams params) {
        AddUpdateCommand addCmd = new AddUpdateCommand();
        boolean overwrite = true;
        Boolean overwritePending = null;
        Object overwriteCommitted = null;
        overwrite = params.getBool("overwrite", overwrite);
        addCmd.commitWithin = params.getInt("commitWithin", -1);
        if (overwritePending != null && overwriteCommitted != null) {
            if (overwritePending != overwriteCommitted) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "can't have different values for 'overwritePending' and 'overwriteCommitted'");
            }
            overwrite = overwritePending;
        }
        addCmd.overwriteCommitted = overwrite;
        addCmd.overwritePending = overwrite;
        addCmd.allowDups = !overwrite;
        return addCmd;
    }

    private void delete(List<String> l, UpdateRequestProcessor processor, boolean isId) throws IOException {
        for (String s : l) {
            DeleteUpdateCommand delcmd = new DeleteUpdateCommand();
            if (isId) {
                delcmd.id = s;
            } else {
                delcmd.query = s;
            }
            delcmd.fromCommitted = true;
            delcmd.fromPending = true;
            processor.processDelete(delcmd);
        }
    }

    @Override
    public String getDescription() {
        return "Add/Update multiple documents with javabin format";
    }

    @Override
    public String getSourceId() {
        return "$Id: BinaryUpdateRequestHandler.java 1065312 2011-01-30 16:08:25Z rmuir $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_1/solr/src/java/org/apache/solr/handler/BinaryUpdateRequestHandler.java $";
    }

    @Override
    public String getVersion() {
        return "$Revision: 1065312 $";
    }
}

