/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDLongArray;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.util.BitSet;

public final class BitSetConversionUtils {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;

    public static BitSet fromStorageForm(long[] serializedWordArray, int start, int length) {
        BitSet result = new BitSet();
        int wordIndex = 0;
        while (wordIndex < length) {
            long word = serializedWordArray[start + wordIndex];
            int bitInWord = 0;
            while (bitInWord < 64) {
                if ((word & 1L << bitInWord) != 0L) {
                    result.set(wordIndex << 6 | bitInWord);
                }
                ++bitInWord;
            }
            ++wordIndex;
        }
        return result;
    }

    public static BitSet fromStorageForm(long[] serializedWordArray) {
        return BitSetConversionUtils.fromStorageForm(serializedWordArray, 0, serializedWordArray.length);
    }

    public static BitSet[] fromStorageForm2D(MDLongArray serializedWordArray) {
        if (serializedWordArray.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + serializedWordArray.rank());
        }
        int dimX = serializedWordArray.dimensions()[0];
        int dimY = serializedWordArray.dimensions()[1];
        BitSet[] result = new BitSet[dimY];
        int i = 0;
        while (i < result.length) {
            result[i] = BitSetConversionUtils.fromStorageForm(serializedWordArray.getAsFlatArray(), i * dimX, dimX);
            ++i;
        }
        return result;
    }

    public static long[] toStorageForm(BitSet data) {
        long[] words = new long[data.size() >> 6];
        int bitIndex = data.nextSetBit(0);
        while (bitIndex >= 0) {
            int wordIndex;
            int n = wordIndex = BitSetConversionUtils.getWordIndex(bitIndex);
            words[n] = words[n] | BitSetConversionUtils.getBitMaskInWord(bitIndex);
            bitIndex = data.nextSetBit(bitIndex + 1);
        }
        return words;
    }

    public static long[] toStorageForm(BitSet data, int numberOfWords) {
        long[] words = new long[numberOfWords];
        int bitIndex = data.nextSetBit(0);
        while (bitIndex >= 0) {
            int wordIndex = BitSetConversionUtils.getWordIndex(bitIndex);
            if (wordIndex >= words.length) break;
            int n = wordIndex;
            words[n] = words[n] | BitSetConversionUtils.getBitMaskInWord(bitIndex);
            bitIndex = data.nextSetBit(bitIndex + 1);
        }
        return words;
    }

    public static long[] toStorageForm(BitSet[] data, int numberOfWords) {
        long[] result = new long[data.length * numberOfWords];
        int idx = 0;
        BitSet[] bitSetArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet bs = bitSetArray[n2];
            System.arraycopy(BitSetConversionUtils.toStorageForm(bs, numberOfWords), 0, result, idx, numberOfWords);
            idx += numberOfWords;
            ++n2;
        }
        return result;
    }

    public static int getWordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    public static long getBitMaskInWord(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    static int getMaxLength(BitSet[] data) {
        int length = 0;
        BitSet[] bitSetArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet bs = bitSetArray[n2];
            length = Math.max(length, bs.length());
            ++n2;
        }
        return length;
    }
}

