/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.io.IOException;
import java.util.ArrayList;
import ucar.bufr.BufrNumbers;
import ucar.unidata.io.RandomAccessFile;

final class BufrDataDescriptionSection {
    private final long offset;
    private final int length;
    private int datasets;
    private final int datatype;
    private final ArrayList descriptors = new ArrayList();

    public BufrDataDescriptionSection(RandomAccessFile raf) throws IOException {
        this.offset = raf.getFilePointer();
        this.length = BufrNumbers.uint3(raf);
        long EOS = raf.getFilePointer() + (long)this.length - 3L;
        int reserved = raf.read();
        this.datasets = BufrNumbers.uint2(raf);
        this.datatype = raf.read();
        int f = 0;
        int x = 0;
        ArrayList rep = new ArrayList();
        for (int i = 8; i <= this.length; i += 2) {
            int fx = raf.read();
            f = (fx & 0xC0) >> 6;
            x = fx & 0x3F;
            int y = raf.read();
            if (f == 0 && x == 0 && y == 0) break;
            String d = Integer.toString(f) + "-" + Integer.toString(x) + "-" + Integer.toString(y);
            this.descriptors.add(d);
        }
        raf.seek(EOS);
    }

    public final long getOffset() {
        return this.offset;
    }

    public final int getNumberDataSets() {
        return this.datasets;
    }

    public final void setNumberDataSets(int datasets) {
        this.datasets = datasets;
    }

    public final int getDataType() {
        return this.datatype;
    }

    public final ArrayList getDescriptors() {
        return this.descriptors;
    }
}

