/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.PreorderDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Method;

public class DontUseEnum
extends PreorderDetector {
    BugReporter bugReporter;

    public DontUseEnum(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        if (this.isReservedName(obj.getName())) {
            BugInstance bug = new BugInstance((Detector)this, "NM_FUTURE_KEYWORD_USED_AS_MEMBER_IDENTIFIER", this.isVisible((FieldOrMethod)obj) ? 1 : 2).addClassAndMethod((PreorderVisitor)this);
            this.bugReporter.reportBug(bug);
        }
    }

    private boolean isVisible(FieldOrMethod obj) {
        return (obj.getAccessFlags() & 1) != 0 || (obj.getAccessFlags() & 4) != 0;
    }

    private boolean isReservedName(String name) {
        return name.equals("enum") || name.equals("assert");
    }

    public void visit(Field obj) {
        if (this.isReservedName(obj.getName())) {
            BugInstance bug = new BugInstance((Detector)this, "NM_FUTURE_KEYWORD_USED_AS_MEMBER_IDENTIFIER", this.isVisible((FieldOrMethod)obj) ? 1 : 2).addClass((PreorderVisitor)this).addField((PreorderVisitor)this);
            this.bugReporter.reportBug(bug);
        }
    }

    public void visit(LocalVariable obj) {
        if (this.isReservedName(obj.getName())) {
            LocalVariableAnnotation var = new LocalVariableAnnotation(obj.getName(), obj.getIndex(), obj.getStartPC());
            SourceLineAnnotation source = SourceLineAnnotation.fromVisitedInstruction((ClassContext)this.getClassContext(), (PreorderVisitor)this, (int)obj.getStartPC());
            BugInstance bug = new BugInstance((Detector)this, "NM_FUTURE_KEYWORD_USED_AS_IDENTIFIER", 2).addClassAndMethod((PreorderVisitor)this).add((BugAnnotation)var).add((BugAnnotation)source);
            this.bugReporter.reportBug(bug);
        }
    }
}

