/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions.stats;

import ome.services.sessions.stats.MethodCounter;
import ome.services.sessions.stats.ObjectsReadCounter;
import ome.services.sessions.stats.ObjectsWrittenCounter;
import ome.services.sessions.stats.SessionStats;

public class SimpleSessionStats
implements SessionStats {
    private final ObjectsReadCounter read;
    private final ObjectsWrittenCounter written;
    private final MethodCounter methods;

    public SimpleSessionStats(ObjectsReadCounter read, ObjectsWrittenCounter written, MethodCounter methods) {
        this.read = read;
        this.written = written;
        this.methods = methods;
    }

    @Override
    public void methodIn() {
        this.methods.increment(1);
    }

    @Override
    public long methodCount() {
        return this.methods.count;
    }

    @Override
    public void methodOut() {
        this.methods.increment(-1);
    }

    @Override
    public void loadedObjects(int objects) {
        this.read.increment(objects);
    }

    @Override
    public void readBytes(int bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updatedObjects(int objects) {
        this.written.increment(objects);
    }

    @Override
    public void writtenBytes(int bytes) {
        throw new UnsupportedOperationException();
    }
}

