/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.utils.Decoder;
import java.util.Collections;
import java.util.List;
import javax.transaction.xa.XAException;

public class PhaseException
extends Exception {
    private final List<Exception> exceptions;
    private final List<XAResourceHolderState> resourceStates;

    public PhaseException(List<Exception> exceptions, List<XAResourceHolderState> resourceStates) {
        this.exceptions = Collections.unmodifiableList(exceptions);
        this.resourceStates = Collections.unmodifiableList(resourceStates);
    }

    @Override
    public String getMessage() {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("collected ");
        errorMessage.append(this.exceptions.size());
        errorMessage.append(" exception(s):");
        for (int i = 0; i < this.exceptions.size(); ++i) {
            errorMessage.append(System.getProperty("line.separator"));
            Throwable throwable = this.exceptions.get(i);
            String message = throwable.getMessage();
            XAResourceHolderState holderState = this.resourceStates.get(i);
            if (holderState != null) {
                errorMessage.append(" [");
                errorMessage.append(holderState.getUniqueName());
                errorMessage.append(" - ");
            }
            errorMessage.append(throwable.getClass().getName());
            if (throwable instanceof XAException) {
                XAException xaEx = (XAException)throwable;
                errorMessage.append("(");
                errorMessage.append(Decoder.decodeXAExceptionErrorCode(xaEx));
                String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(xaEx);
                if (extraErrorDetails != null && extraErrorDetails.trim().length() > 0) {
                    errorMessage.append(" - ").append(extraErrorDetails);
                }
                errorMessage.append(")");
            }
            errorMessage.append(" - ");
            errorMessage.append(message);
            errorMessage.append("]");
        }
        return errorMessage.toString();
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public List<XAResourceHolderState> getResourceStates() {
        return this.resourceStates;
    }
}

