/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr.ucar;

import com.bc.zarr.DataType;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;

public class NetCDF_Util {
    public static int[] netCDFOrder(int[] ints) {
        int length = ints.length;
        int[] netCDF = new int[length];
        for (int i = 0; i < length; ++i) {
            netCDF[i] = ints[length - 1 - i];
        }
        return netCDF;
    }

    public static Array createArrayWithGivenStorage(Object storage, int[] shape) {
        Class<?> aClass = storage.getClass();
        if (aClass.isArray()) {
            return Array.factory((ucar.ma2.DataType)ucar.ma2.DataType.getType(aClass.getComponentType(), (boolean)false), (int[])shape, (Object)storage);
        }
        return null;
    }

    public static Array createFilledArray(ucar.ma2.DataType dataType, int[] shape, Number fill) {
        Array array = Array.factory((ucar.ma2.DataType)dataType, (int[])shape);
        IndexIterator iter = array.getIndexIterator();
        if (fill != null) {
            if (ucar.ma2.DataType.DOUBLE.equals((Object)dataType)) {
                while (iter.hasNext()) {
                    iter.setDoubleNext(fill.doubleValue());
                }
            } else if (ucar.ma2.DataType.FLOAT.equals((Object)dataType)) {
                while (iter.hasNext()) {
                    iter.setFloatNext(fill.floatValue());
                }
            } else if (ucar.ma2.DataType.LONG.equals((Object)dataType)) {
                while (iter.hasNext()) {
                    iter.setLongNext(fill.longValue());
                }
            } else if (ucar.ma2.DataType.INT.equals((Object)dataType)) {
                while (iter.hasNext()) {
                    iter.setIntNext(fill.intValue());
                }
            } else if (ucar.ma2.DataType.SHORT.equals((Object)dataType)) {
                while (iter.hasNext()) {
                    iter.setShortNext(fill.shortValue());
                }
            } else if (ucar.ma2.DataType.BYTE.equals((Object)dataType)) {
                while (iter.hasNext()) {
                    iter.setByteNext(fill.byteValue());
                }
            } else {
                throw new IllegalStateException();
            }
        }
        return array;
    }

    public static ucar.ma2.DataType getDataType(DataType dataType) {
        if (dataType == DataType.f8) {
            return ucar.ma2.DataType.DOUBLE;
        }
        if (dataType == DataType.f4) {
            return ucar.ma2.DataType.FLOAT;
        }
        if (dataType == DataType.i8) {
            return ucar.ma2.DataType.LONG;
        }
        if (dataType == DataType.i4 || dataType == DataType.u4) {
            return ucar.ma2.DataType.INT;
        }
        if (dataType == DataType.i2 || dataType == DataType.u2) {
            return ucar.ma2.DataType.SHORT;
        }
        return ucar.ma2.DataType.BYTE;
    }
}

