/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.Service;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.builder.AccessBuilder;

public class DatasetBuilder {
    protected DatasetBuilder parent;
    protected String name;
    protected Map<String, Object> flds = new HashMap<String, Object>(10);
    protected List<AccessBuilder> accessBuilders;
    protected List<DatasetBuilder> datasetBuilders;
    protected List<Service> services;

    public static void addToList(Map<String, Object> flds, String fldName, Object fldValue) {
        ArrayList<Object> prevList;
        if (fldValue == null) {
            return;
        }
        Object prevVal = flds.get(fldName);
        if (prevVal == null) {
            flds.put(fldName, fldValue);
            return;
        }
        if (prevVal instanceof List) {
            prevList = (ArrayList<Object>)prevVal;
        } else {
            prevList = new ArrayList<Object>(5);
            prevList.add(prevVal);
            flds.put(fldName, prevList);
        }
        if (fldValue instanceof List) {
            prevList.addAll((List)fldValue);
        } else {
            prevList.add(fldValue);
        }
    }

    public static void addToNewList(Map<String, Object> flds, String fldName, Object fldValue) {
        ArrayList<Object> prevList;
        if (fldValue == null) {
            return;
        }
        Object prevVal = flds.get(fldName);
        if (prevVal == null) {
            prevList = new ArrayList<Object>(5);
            flds.put(fldName, prevList);
        } else {
            prevList = (ArrayList<Object>)prevVal;
        }
        if (fldValue instanceof List) {
            prevList.addAll((List)fldValue);
        } else {
            prevList.add(fldValue);
        }
    }

    public DatasetBuilder(DatasetBuilder parent) {
        this.parent = parent;
    }

    public DatasetBuilder(DatasetBuilder parent, Dataset from) {
        this.parent = parent;
        this.name = from.getName();
        for (Map.Entry<String, Object> entry : from.getFldIterator()) {
            if (entry.getKey().equals("Datasets") || entry.getKey().equals("Access")) continue;
            this.flds.put(entry.getKey(), entry.getValue());
        }
    }

    public DatasetBuilder getParent() {
        return this.parent;
    }

    private Object getInherited(String fldName) {
        Object value;
        ThreddsMetadata tmi = (ThreddsMetadata)this.get("ThreddsMetadataInheritable");
        if (tmi != null && (value = tmi.getLocalField(fldName)) != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.getInherited(fldName);
        }
        return null;
    }

    public Object getFldOrInherited(String fldName) {
        Object value = this.flds.get(fldName);
        if (value != null) {
            return value;
        }
        return this.getInherited(fldName);
    }

    public Object get(String fldName) {
        return this.flds.get(fldName);
    }

    public void put(String fldName, Object fldValue) {
        if (fldValue != null) {
            this.flds.put(fldName, fldValue);
        } else {
            this.flds.remove(fldName);
        }
    }

    public void putInheritedField(String fldName, Object fldValue) {
        if (fldValue == null) {
            return;
        }
        ThreddsMetadata tmi = (ThreddsMetadata)this.get("ThreddsMetadataInheritable");
        if (tmi == null) {
            tmi = new ThreddsMetadata();
            this.put("ThreddsMetadataInheritable", tmi);
        }
        tmi.getFlds().put(fldName, fldValue);
    }

    public void addToList(String fldName, Object fldValue) {
        if (fldValue != null) {
            DatasetBuilder.addToList(this.flds, fldName, fldValue);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addDataset(DatasetBuilder d) {
        if (d == null) {
            return;
        }
        if (this.datasetBuilders == null) {
            this.datasetBuilders = new ArrayList<DatasetBuilder>();
        }
        this.datasetBuilders.add(d);
    }

    public void addAccess(AccessBuilder d) {
        if (this.accessBuilders == null) {
            this.accessBuilders = new ArrayList<AccessBuilder>();
        }
        this.accessBuilders.add(d);
    }

    public void addServiceToCatalog(Service s) {
        if (s == null) {
            return;
        }
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.add(s);
    }

    public Dataset makeDataset(DatasetNode parent) {
        ThreddsMetadata tmi = (ThreddsMetadata)this.get("ThreddsMetadataInheritable");
        if (tmi != null) {
            tmi.finish();
        }
        return new Dataset(parent, this.name, this.flds, this.accessBuilders, this.datasetBuilders);
    }

    public Dataset copyDataset(DatasetNode parent) {
        return new Dataset(parent, this.name, this.flds, this.accessBuilders, this.datasetBuilders);
    }

    public Iterable<DatasetBuilder> getDatasets() {
        if (this.datasetBuilders != null) {
            return this.datasetBuilders;
        }
        return new ArrayList<DatasetBuilder>(0);
    }

    public Iterable<Service> getServices() {
        if (this.services != null) {
            return this.services;
        }
        return new ArrayList<Service>(0);
    }

    public void transferMetadata(DatasetNode from, boolean parentsAlso) {
        if (parentsAlso) {
            ThreddsMetadata inherit = this.getInheritableMetadata();
            this.inheritMetadata(from, inherit.getFlds());
        }
        for (Map.Entry entry : from.getFldIterator()) {
            if (parentsAlso && ((String)entry.getKey()).equals("ThreddsMetadataInheritable")) continue;
            if (Dataset.listFlds.contains(entry.getKey())) {
                DatasetBuilder.addToNewList(this.flds, (String)entry.getKey(), entry.getValue());
                continue;
            }
            this.flds.put((String)entry.getKey(), entry.getValue());
        }
        ThreddsMetadata tmiOld = (ThreddsMetadata)this.get("ThreddsMetadataInheritable");
        if (tmiOld != null && tmiOld.isImmutable()) {
            ThreddsMetadata threddsMetadata = new ThreddsMetadata(tmiOld);
            this.flds.put("ThreddsMetadataInheritable", threddsMetadata);
        }
    }

    public void transferInheritedMetadata(DatasetNode from) {
        ThreddsMetadata tmi = this.getInheritableMetadata();
        this.inheritMetadata(from, tmi.getFlds());
    }

    private void inheritMetadata(DatasetNode from, Map<String, Object> toFlds) {
        ThreddsMetadata tmi;
        Dataset fromParent = from.getParentDataset();
        if (fromParent != null) {
            this.inheritMetadata(fromParent, toFlds);
        }
        if ((tmi = (ThreddsMetadata)from.get("ThreddsMetadataInheritable")) == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : tmi.getFldIterator()) {
            if (Dataset.listFlds.contains((Object)entry.getKey())) {
                DatasetBuilder.addToNewList(toFlds, entry.getKey(), entry.getValue());
                continue;
            }
            toFlds.put(entry.getKey(), entry.getValue());
        }
    }

    public ThreddsMetadata getInheritableMetadata() {
        ThreddsMetadata tmi = (ThreddsMetadata)this.get("ThreddsMetadataInheritable");
        if (tmi == null) {
            tmi = new ThreddsMetadata();
            this.put("ThreddsMetadataInheritable", tmi);
        }
        return tmi;
    }
}

