/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneDictionary
implements Dictionary {
    private IndexReader reader;
    private String field;

    public LuceneDictionary(IndexReader reader, String field) {
        this.reader = reader;
        this.field = StringHelper.intern((String)field);
    }

    @Override
    public final Iterator<String> getWordsIterator() {
        return new LuceneIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class LuceneIterator
    implements Iterator<String> {
        private TermEnum termEnum;
        private Term actualTerm;
        private boolean hasNextCalled;

        LuceneIterator() {
            try {
                this.termEnum = LuceneDictionary.this.reader.terms(new Term(LuceneDictionary.this.field));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String next() {
            if (!this.hasNextCalled) {
                this.hasNext();
            }
            this.hasNextCalled = false;
            try {
                this.termEnum.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.actualTerm != null ? this.actualTerm.text() : null;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNextCalled) {
                return this.actualTerm != null;
            }
            this.hasNextCalled = true;
            this.actualTerm = this.termEnum.term();
            if (this.actualTerm == null) {
                return false;
            }
            String currentField = this.actualTerm.field();
            if (currentField != LuceneDictionary.this.field) {
                this.actualTerm = null;
                return false;
            }
            return true;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

