/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr;

import com.bc.zarr.Compressor;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sun.jna.ptr.NativeLongByReference;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.blosc.BufferSizes;
import org.blosc.IBloscDll;
import org.blosc.JBlosc;

public class CompressorFactory {
    public static final Compressor nullCompressor = new NullCompressor();

    public static Map<String, Object> getDefaultCompressorProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", "blosc");
        map.putAll(BloscCompressor.defaultProperties);
        return map;
    }

    public static Compressor createDefaultCompressor() {
        return CompressorFactory.create(CompressorFactory.getDefaultCompressorProperties());
    }

    public static Compressor create(Map<String, Object> properties) {
        String id = (String)properties.get("id");
        return CompressorFactory.create(id, properties);
    }

    public static Compressor create(String id, Object ... keyValuePair) {
        if (keyValuePair.length % 2 != 0) {
            throw new IllegalArgumentException("The count of keyValuePair arguments must be an even count.");
        }
        return CompressorFactory.create(id, CompressorFactory.toMap(keyValuePair));
    }

    public static Compressor create(String id, Map<String, Object> properties) {
        if ("null".equals(id)) {
            return nullCompressor;
        }
        if ("zlib".equals(id)) {
            return new ZlibCompressor(properties);
        }
        if ("blosc".equals(id)) {
            return new BloscCompressor(properties);
        }
        throw new IllegalArgumentException("Compressor id:'" + id + "' not supported.");
    }

    private static Map<String, Object> toMap(Object ... args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            String key = (String)args[i];
            Object val = args[i + 1];
            map.put(key, val);
        }
        return map;
    }

    public static class BloscCompressor
    extends Compressor {
        static final int AUTOSHUFFLE = -1;
        static final int NOSHUFFLE = 0;
        static final int BYTESHUFFLE = 1;
        static final int BITSHUFFLE = 2;
        public static final String keyCname = "cname";
        public static final String defaultCname = "lz4";
        public static final String keyClevel = "clevel";
        public static final int defaultCLevel = 5;
        public static final String keyShuffle = "shuffle";
        public static final int defaultShuffle = 1;
        public static final String keyBlocksize = "blocksize";
        public static final int defaultBlocksize = 0;
        public static final String keyNumThreads = "nthreads";
        public static final int defaultNumThreads = 1;
        public static final int[] supportedShuffle = new int[]{0, 1, 2};
        public static final String[] supportedCnames = new String[]{"zstd", "blosclz", "lz4", "lz4hc", "zlib"};
        public static final Map<String, Object> defaultProperties = new HashMap<String, Object>(){
            {
                this.put(BloscCompressor.keyCname, BloscCompressor.defaultCname);
                this.put(BloscCompressor.keyClevel, 5);
                this.put(BloscCompressor.keyShuffle, 1);
                this.put(BloscCompressor.keyBlocksize, 0);
                this.put(BloscCompressor.keyNumThreads, 1);
            }
        };
        private final int clevel;
        private final int blocksize;
        private final int shuffle;
        private final String cname;
        private final int nthreads;

        private BloscCompressor(Map<String, Object> map) {
            Object cnameObj = map.get(keyCname);
            this.cname = cnameObj == null ? defaultCname : (String)cnameObj;
            if (Arrays.stream(supportedCnames).noneMatch(this.cname::equals)) {
                throw new IllegalArgumentException("blosc: compressor not supported: '" + this.cname + "'; expected one of " + Arrays.toString(supportedCnames));
            }
            Object clevelObj = map.get(keyClevel);
            this.clevel = clevelObj == null ? 5 : (clevelObj instanceof String ? Integer.parseInt((String)clevelObj) : ((Number)clevelObj).intValue());
            if (this.clevel < 0 || this.clevel > 9) {
                throw new IllegalArgumentException("blosc: clevel parameter must be between 0 and 9 but was: " + this.clevel);
            }
            Object shuffleObj = map.get(keyShuffle);
            this.shuffle = shuffleObj == null ? 1 : (shuffleObj instanceof String ? Integer.parseInt((String)shuffleObj) : ((Number)shuffleObj).intValue());
            Object[] supportedShuffleNames = new String[]{"0 (NOSHUFFLE)", "1 (BYTESHUFFLE)", "2 (BITSHUFFLE)"};
            if (Arrays.stream(supportedShuffle).noneMatch(value -> value == this.shuffle)) {
                throw new IllegalArgumentException("blosc: shuffle type not supported: '" + this.shuffle + "'; expected one of " + Arrays.toString(supportedShuffleNames));
            }
            Object blocksizeObj = map.get(keyBlocksize);
            this.blocksize = blocksizeObj == null ? 0 : (blocksizeObj instanceof String ? Integer.parseInt((String)blocksizeObj) : ((Number)blocksizeObj).intValue());
            Object nthreadsObj = map.get(keyNumThreads);
            if (nthreadsObj == null) {
                nthreadsObj = defaultProperties.get(keyNumThreads);
            }
            this.nthreads = nthreadsObj instanceof String ? Integer.parseInt((String)nthreadsObj) : ((Number)nthreadsObj).intValue();
        }

        @Override
        public String getId() {
            return "blosc";
        }

        public int getClevel() {
            return this.clevel;
        }

        public int getBlocksize() {
            return this.blocksize;
        }

        public int getShuffle() {
            return this.shuffle;
        }

        public String getCname() {
            return this.cname;
        }

        @JsonIgnore
        public int getNumThreads() {
            return this.nthreads;
        }

        @Override
        public String toString() {
            return "compressor=" + this.getId() + "/cname=" + this.cname + "/clevel=" + this.clevel + "/blocksize=" + this.blocksize + "/shuffle=" + this.shuffle;
        }

        @Override
        public void compress(InputStream is, OutputStream os) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.passThrough(is, baos);
            byte[] inputBytes = baos.toByteArray();
            int inputSize = inputBytes.length;
            int outputSize = inputSize + 16;
            ByteBuffer inputBuffer = ByteBuffer.wrap(inputBytes);
            ByteBuffer outBuffer = ByteBuffer.allocate(outputSize);
            int i = JBlosc.compressCtx((int)this.clevel, (int)this.shuffle, (int)1, (ByteBuffer)inputBuffer, (long)inputSize, (ByteBuffer)outBuffer, (long)outputSize, (String)this.cname, (int)this.blocksize, (int)this.nthreads);
            BufferSizes bs = this.cbufferSizes(outBuffer);
            byte[] compressedChunk = Arrays.copyOfRange(outBuffer.array(), 0, (int)bs.getCbytes());
            os.write(compressedChunk);
        }

        @Override
        public void uncompress(InputStream is, OutputStream os) throws IOException {
            DataInputStream di = new DataInputStream(is);
            byte[] header = new byte[16];
            di.readFully(header);
            BufferSizes bs = this.cbufferSizes(ByteBuffer.wrap(header));
            int compressedSize = (int)bs.getCbytes();
            int uncompressedSize = (int)bs.getNbytes();
            byte[] inBytes = Arrays.copyOf(header, compressedSize);
            di.readFully(inBytes, header.length, compressedSize - header.length);
            ByteBuffer outBuffer = ByteBuffer.allocate(uncompressedSize);
            JBlosc.decompressCtx((Buffer)ByteBuffer.wrap(inBytes), (Buffer)outBuffer, (long)outBuffer.limit(), (int)this.nthreads);
            os.write(outBuffer.array());
        }

        private BufferSizes cbufferSizes(ByteBuffer cbuffer) {
            NativeLongByReference nbytes = new NativeLongByReference();
            NativeLongByReference cbytes = new NativeLongByReference();
            NativeLongByReference blocksize = new NativeLongByReference();
            IBloscDll.blosc_cbuffer_sizes((Buffer)cbuffer, (NativeLongByReference)nbytes, (NativeLongByReference)cbytes, (NativeLongByReference)blocksize);
            BufferSizes bs = new BufferSizes(nbytes.getValue().longValue(), cbytes.getValue().longValue(), blocksize.getValue().longValue());
            return bs;
        }
    }

    private static class ZlibCompressor
    extends Compressor {
        private final int level;

        private ZlibCompressor(Map<String, Object> map) {
            Object levelObj = map.get("level");
            this.level = levelObj == null ? 1 : (levelObj instanceof String ? Integer.parseInt((String)levelObj) : ((Number)levelObj).intValue());
            this.validateLevel();
        }

        @Override
        public String toString() {
            return "compressor=" + this.getId() + "/level=" + this.level;
        }

        private void validateLevel() {
            if (this.level < 0 || this.level > 9) {
                throw new IllegalArgumentException("Invalid compression level: " + this.level);
            }
        }

        @Override
        public String getId() {
            return "zlib";
        }

        public int getLevel() {
            return this.level;
        }

        @Override
        public void compress(InputStream is, OutputStream os) throws IOException {
            try (DeflaterOutputStream dos = new DeflaterOutputStream(os, new Deflater(this.level));){
                this.passThrough(is, dos);
            }
        }

        @Override
        public void uncompress(InputStream is, OutputStream os) throws IOException {
            try (InflaterInputStream iis = new InflaterInputStream(is, new Inflater());){
                this.passThrough(iis, os);
            }
        }
    }

    private static class NullCompressor
    extends Compressor {
        private NullCompressor() {
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public String toString() {
            return this.getId();
        }

        @Override
        public void compress(InputStream is, OutputStream os) throws IOException {
            this.passThrough(is, os);
        }

        @Override
        public void uncompress(InputStream is, OutputStream os) throws IOException {
            this.passThrough(is, os);
        }
    }
}

