/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.CryptoEngine;
import bitronix.tm.utils.PropertyUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XAFactoryHelper {
    private static final Logger log = LoggerFactory.getLogger(XAFactoryHelper.class);
    private static final String PASSWORD_PROPERTY_NAME = "password";

    private XAFactoryHelper() {
    }

    static Object createXAFactory(ResourceBean bean) throws Exception {
        String className = bean.getClassName();
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null");
        }
        Class xaFactoryClass = ClassLoaderUtils.loadClass(className);
        Object xaFactory = xaFactoryClass.newInstance();
        for (Map.Entry<Object, Object> entry : bean.getDriverProperties().entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (name.endsWith(PASSWORD_PROPERTY_NAME)) {
                value = XAFactoryHelper.decrypt(value.toString());
            }
            if (log.isDebugEnabled()) {
                log.debug("setting vendor property '" + name + "' to '" + value + "'");
            }
            PropertyUtils.setProperty(xaFactory, name, value);
        }
        return xaFactory;
    }

    private static String decrypt(String resourcePassword) throws Exception {
        int startIdx = resourcePassword.indexOf("{");
        int endIdx = resourcePassword.indexOf("}");
        if (startIdx != 0 || endIdx == -1) {
            return resourcePassword;
        }
        String cipher = resourcePassword.substring(1, endIdx);
        if (log.isDebugEnabled()) {
            log.debug("resource password is encrypted, decrypting " + resourcePassword);
        }
        return CryptoEngine.decrypt(cipher, resourcePassword.substring(endIdx + 1));
    }
}

